/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.captcha;

import com.kg.component.captcha.CaptchaConfig;
import com.kg.component.captcha.CaptchaResult;
import com.kg.component.captcha.CaptchaTypeEnum;
import com.kg.component.captcha.cover.MyArithmeticCaptcha;
import com.kg.component.captcha.cover.MyChineseCaptcha;
import com.kg.component.captcha.cover.MyChineseGifCaptcha;
import com.kg.component.captcha.cover.MyGifCaptcha;
import com.kg.component.captcha.cover.MySpecCaptcha;
import com.kg.component.utils.GuidUtils;
import com.wf.captcha.base.Captcha;
import java.awt.Font;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CaptchaUtils {
    @Resource
    private CaptchaConfig config;

    public CaptchaResult getCaptcha() {
        CaptchaResult cr = new CaptchaResult();
        cr.setCodeExpire(new Date(new Date().getTime() + this.config.getExpiration() * 60L * 1000L));
        Captcha captcha = this.createCaptcha();
        cr.setCodeUuid(GuidUtils.getUuid());
        String captchaValue = captcha.text();
        if (captcha.getCharType() - 1 == CaptchaTypeEnum.ARITHMETIC.ordinal() && captchaValue.contains(".")) {
            captchaValue = captchaValue.split("\\.")[0];
        }
        cr.setCodeValue(captchaValue);
        cr.setCodeBaseImage(captcha.toBase64());
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Captcha createCaptcha() {
        Object captcha = null;
        CaptchaUtils captchaUtils = this;
        synchronized (captchaUtils) {
            switch (this.config.getCaptchaType()) {
                case ARITHMETIC: {
                    captcha = new MyArithmeticCaptcha(this.config.getWidth(), this.config.getHeight(), this.config);
                    captcha.setLen(this.config.getLength());
                    break;
                }
                case CHINESE: {
                    captcha = new MyChineseCaptcha(this.config.getWidth(), this.config.getHeight(), this.config);
                    captcha.setLen(this.config.getLength());
                    break;
                }
                case CHINESE_GIF: {
                    captcha = new MyChineseGifCaptcha(this.config.getWidth(), this.config.getHeight(), this.config);
                    captcha.setLen(this.config.getLength());
                    break;
                }
                case GIF: {
                    captcha = new MyGifCaptcha(this.config.getWidth(), this.config.getHeight(), this.config);
                    captcha.setLen(this.config.getLength());
                    break;
                }
                case SPEC: {
                    captcha = new MySpecCaptcha(this.config.getWidth(), this.config.getHeight(), this.config);
                    captcha.setLen(this.config.getLength());
                }
                default: {
                    System.out.println("\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff01");
                }
            }
        }
        captcha.setFont(new Font(this.config.getFontFamily(), this.config.getFontStyle(), this.config.getFontSize()));
        return captcha;
    }

    public void setConfig(CaptchaConfig config) {
        this.config = config;
    }

    public CaptchaConfig getConfig() {
        return this.config;
    }
}

