/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.captcha.cover;

import com.kg.component.captcha.CaptchaConfig;
import com.wf.captcha.SpecCaptcha;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.springframework.util.StringUtils;

public class MySpecCaptcha
extends SpecCaptcha {
    private CaptchaConfig config;

    public MySpecCaptcha(int width, int height, CaptchaConfig captchaConfig) {
        super(width, height);
        this.config = captchaConfig;
    }

    public boolean out(OutputStream out) {
        return this.graphicsImage(this.textChar(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean graphicsImage(char[] strs, OutputStream out) {
        try {
            Graphics2D g2d;
            BufferedImage bi;
            if (null != this.config.getBgColor() && StringUtils.hasText((String)this.config.getBgColor())) {
                bi = new BufferedImage(this.width, this.height, 1);
                g2d = (Graphics2D)bi.getGraphics();
                g2d.setColor(new Color(Integer.parseInt(this.config.getBgColor(), 16)));
                g2d.fillRect(0, 0, this.width, this.height);
            } else {
                bi = new BufferedImage(this.width, this.height, 2);
                g2d = (Graphics2D)bi.getGraphics();
                g2d.setComposite(AlphaComposite.getInstance(1, 0.0f));
                g2d.fillRect(0, 0, this.width, this.height);
                g2d.setComposite(AlphaComposite.Src);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.drawOval(2, g2d);
            g2d.setStroke(new BasicStroke(2.0f, 0, 2));
            this.drawBesselLine(1, g2d);
            g2d.setFont(this.getFont());
            FontMetrics fontMetrics = g2d.getFontMetrics();
            int fW = this.width / strs.length;
            int fSp = (fW - (int)fontMetrics.getStringBounds("W", g2d).getWidth()) / 2;
            for (int i = 0; i < strs.length; ++i) {
                if (null != this.config.getFontColor() && StringUtils.hasText((String)this.config.getFontColor())) {
                    g2d.setColor(new Color(Integer.parseInt(this.config.getFontColor(), 16)));
                } else {
                    g2d.setColor(this.color());
                }
                int fY = this.height - (this.height - (int)fontMetrics.getStringBounds(String.valueOf(strs[i]), g2d).getHeight() >> 1);
                g2d.drawString(String.valueOf(strs[i]), i * fW + fSp + 3, fY - 3);
            }
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", out);
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

