/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.desensitized;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.kg.component.desensitized.DesensitizedType;
import com.kg.component.desensitized.JsonDesensitized;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonDesensitizedUtils
extends JsonSerializer<String>
implements ContextualSerializer {
    private DesensitizedType type;

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                JsonDesensitized jsonDesensitized = (JsonDesensitized)beanProperty.getAnnotation(JsonDesensitized.class);
                if (jsonDesensitized == null) {
                    jsonDesensitized = (JsonDesensitized)beanProperty.getContextAnnotation(JsonDesensitized.class);
                }
                if (jsonDesensitized != null) {
                    return new JsonDesensitizedUtils(jsonDesensitized.value());
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(beanProperty);
    }

    public void serialize(String str, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        switch (this.type) {
            case CHINESE_NAME: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)0, (int)(str.length() - 1)));
                break;
            }
            case ENGLISH_NAME: {
                jsonGenerator.writeString(JsonDesensitizedUtils.englishName(str));
                break;
            }
            case ID_CARD: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)1, (int)(str.length() - 1)));
                break;
            }
            case MOBILE_PHONE: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)3, (int)(str.length() - 2)));
                break;
            }
            case FIXED_PHONE: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)4, (int)(str.length() - 2)));
                break;
            }
            case BANK_CARD: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)0, (int)(str.length() - 4)));
                break;
            }
            case CAR_LICENSE: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)2, (int)(str.length() - 3)));
                break;
            }
            case EMAIL: {
                jsonGenerator.writeString(JsonDesensitizedUtils.email(str));
                break;
            }
            case ADDRESS: {
                jsonGenerator.writeString(JsonDesensitizedUtils.address(str));
                break;
            }
            case PASSWORD: {
                jsonGenerator.writeString(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.repeat((char)'*', (int)str.length()));
                break;
            }
            case OTHER: {
                jsonGenerator.writeString(JsonDesensitizedUtils.other(str));
                break;
            }
        }
    }

    public static String englishName(String fullName) {
        if (StrUtil.isBlank((CharSequence)fullName)) {
            return "";
        }
        Matcher matcher = Pattern.compile("[A-Z]").matcher(fullName);
        ArrayList<String> nameList = new ArrayList<String>();
        int i = 0;
        while (matcher.find()) {
            int position = matcher.start();
            if (position <= 0) continue;
            nameList.add(fullName.substring(i, position));
            i = position;
        }
        if (i < fullName.length()) {
            nameList.add(fullName.substring(i, fullName.length()));
        }
        if (nameList.size() > 1) {
            String result = "";
            for (int j = 0; j < nameList.size(); ++j) {
                result = j == 0 ? result + StrUtil.hide((CharSequence)((CharSequence)nameList.get(j)), (int)0, (int)((String)nameList.get(j)).length()) : result + (String)nameList.get(j);
            }
            return result;
        }
        return StrUtil.hide((CharSequence)fullName, (int)1, (int)fullName.length());
    }

    public static String email(String email) {
        if (StrUtil.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StrUtil.indexOf((CharSequence)email, (char)'@');
        return index <= 1 ? email : StrUtil.hide((CharSequence)email, (int)0, (int)index);
    }

    public static String address(String address) {
        if (StrUtil.isBlank((CharSequence)address)) {
            return "";
        }
        int length = address.length();
        if (length <= 12) {
            return StrUtil.hide((CharSequence)address, (int)(length / 2), (int)length);
        }
        return StrUtil.hide((CharSequence)address, (int)6, (int)length);
    }

    public static String other(String other) {
        if (StrUtil.isBlank((CharSequence)other)) {
            return "";
        }
        int length = other.length();
        return StrUtil.hide((CharSequence)other, (int)(length / 3), (int)(length - length / 3));
    }

    public static void main(String[] args) {
        String str = "11223456789";
        System.out.println(StrUtil.isBlank((CharSequence)str) ? "" : StrUtil.hide((CharSequence)str, (int)4, (int)(str.length() - 2)));
        System.out.println(JsonDesensitizedUtils.englishName("Dsdfsad Asdlfkj Osldkfz Klsdkfx"));
        System.out.println(JsonDesensitizedUtils.email("abcdef@qq.com"));
        System.out.println(JsonDesensitizedUtils.address("\u5c71\u4e1c\u7701"));
        System.out.println(JsonDesensitizedUtils.address("\u5c71\u4e1c\u7701\u6f4d\u574a\u5e02"));
        System.out.println(JsonDesensitizedUtils.address("\u5c71\u4e1c\u7701XX\u5e02XX\u53bf"));
        System.out.println(JsonDesensitizedUtils.address("\u5c71\u4e1c\u7701XX\u5e02XX\u53bfXX\u5927\u53a6"));
        System.out.println(JsonDesensitizedUtils.address("\u5c71\u4e1c\u7701XX\u5e02XX\u53bfXX\u5927\u53a6XXXX"));
        System.out.println("------------");
        System.out.println(JsonDesensitizedUtils.other("abcdef"));
    }

    public DesensitizedType getType() {
        return this.type;
    }

    public void setType(DesensitizedType type) {
        this.type = type;
    }

    public JsonDesensitizedUtils(DesensitizedType type) {
        this.type = type;
    }

    public JsonDesensitizedUtils() {
    }
}

