/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.file.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.img.Img;
import cn.hutool.core.io.FileUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import com.kg.component.utils.GuidUtils;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.imageio.ImageIO;

public class DownloadNetFileUtils {
    public static boolean isExists(String fileUrl) {
        return HttpRequest.head((String)fileUrl).execute().isOk();
    }

    public static long getFileSize(String fileUrl) {
        return Long.parseLong(HttpRequest.head((String)fileUrl).execute().header(Header.CONTENT_LENGTH));
    }

    public static String getExtend(String fileUrl) {
        String contentType = HttpRequest.head((String)fileUrl).execute().header(Header.CONTENT_TYPE);
        return contentType.split("/")[1].toLowerCase();
    }

    public static FileDTO downloadImgCompress(String fileUrl, String dirName) {
        return DownloadNetFileUtils.download(fileUrl, dirName, true);
    }

    public static FileDTO download(String fileUrl, String dirName) {
        return DownloadNetFileUtils.download(fileUrl, dirName, false);
    }

    private static FileDTO download(String fileUrl, String dirName, boolean isCompress) {
        File saveFile;
        String extend = DownloadNetFileUtils.getExtend(fileUrl);
        FileDTO fileDto = new FileDTO();
        fileDto.setFileExtend(extend);
        fileDto.setFileName(GuidUtils.getUuid32() + "." + extend);
        String savePath = FilePathConfig.SAVE_PATH + "/" + dirName + "/" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "/" + fileDto.getFileName();
        savePath = savePath.replaceAll("//", "/");
        FileUtil.mkParentDirs((String)savePath);
        if (FilePathConfig.DEFAULT_IMAGE_FILE_EXTEND.toLowerCase().indexOf(extend) >= 0) {
            try {
                byte[] bytes = HttpUtil.downloadBytes((String)fileUrl);
                ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(bytes)), extend, new File(savePath));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            saveFile = new File(savePath);
            if (isCompress) {
                Img.from((InputStream)FileUtil.getInputStream((File)saveFile)).setQuality(0.6).write((OutputStream)FileUtil.getOutputStream((File)saveFile));
            }
        } else {
            saveFile = HttpUtil.downloadFileFromUrl((String)fileUrl, (String)savePath);
        }
        fileDto.setFileSize(saveFile.length());
        fileDto.setFileUrl(FilePathConfig.switchUrl(savePath));
        return fileDto;
    }
}

