/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.file.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileChunkDTO;
import com.kg.component.file.utils.FileMD5Utils;
import com.kg.component.utils.GuidUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class UploadFileChunksUtils {
    private static final String FILE_CHUNK_TEMP_PATH = FilePathConfig.SAVE_PATH + "/chunks/temp/" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "/";

    public static FileChunkDTO upload(HttpServletRequest request, String dirName, String chunkNumber, String tempFileName, String uploadId, String totalChunks) throws IOException {
        FileChunkDTO result = new FileChunkDTO();
        MultipartFile multipartFile = ((MultipartHttpServletRequest)request).getFile("file");
        String chunkFileName = UploadFileChunksUtils.getFileChunkTempPath(tempFileName, uploadId, chunkNumber);
        FileUtil.mkParentDirs((String)chunkFileName);
        multipartFile.transferTo(new File(chunkFileName));
        if (!UploadFileChunksUtils.isAllChunksUploaded(tempFileName, uploadId, totalChunks)) {
            result.setChunkNumber(chunkNumber);
            result.setFileOldName(tempFileName);
            result.setFileUrl(FilePathConfig.switchUrl(chunkFileName));
            result.setFileMd5(FileMD5Utils.getFileMD5(chunkFileName));
            result.setMerged(false);
            return result;
        }
        return UploadFileChunksUtils.mergeChunks(dirName, tempFileName, uploadId, totalChunks);
    }

    public static FileChunkDTO mergeChunks(String dirName, String tempFileName, String uploadId, String totalChunks) throws IOException {
        String extend = FileUtil.extName((String)tempFileName).toLowerCase();
        String saveFileName = GuidUtils.getUuid32() + "." + extend;
        String savePath = FilePathConfig.SAVE_PATH + "/" + dirName + "/" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "/" + saveFileName;
        FileUtil.mkParentDirs((String)savePath);
        UploadFileChunksUtils.mergeChunksSave(tempFileName, uploadId, totalChunks, savePath);
        UploadFileChunksUtils.deleteChunks(tempFileName, uploadId, totalChunks);
        FileChunkDTO result = new FileChunkDTO();
        result.setFileMd5(FileMD5Utils.getFileMD5(savePath));
        result.setFileUrl(FilePathConfig.switchUrl(savePath));
        result.setFileOldName(tempFileName);
        result.setFileName(saveFileName);
        result.setFileExtend(extend);
        result.setFileSize(new File(savePath).length());
        result.setMerged(true);
        return result;
    }

    public static boolean isAllChunksUploaded(String tempFileName, String uploadId, String totalChunks) {
        for (int i = 0; i < Integer.parseInt(totalChunks); ++i) {
            String chunkFileName = UploadFileChunksUtils.getFileChunkTempPath(tempFileName, uploadId, i + "");
            File chunkFile = new File(chunkFileName);
            if (chunkFile.exists()) continue;
            return false;
        }
        return true;
    }

    public static void mergeChunksSave(String tempFileName, String uploadId, String totalChunks, String savePath) throws IOException {
        File mergedFile = new File(savePath);
        FileOutputStream fos = new FileOutputStream(mergedFile, true);
        for (int i = 0; i < Integer.parseInt(totalChunks); ++i) {
            int len;
            String chunkFileName = UploadFileChunksUtils.getFileChunkTempPath(tempFileName, uploadId, i + "");
            File chunkFile = new File(chunkFileName);
            FileInputStream fis = new FileInputStream(chunkFile);
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fis.close();
            chunkFile.delete();
        }
        fos.close();
    }

    public static void deleteChunks(String tempFileName, String uploadId, String totalChunks) {
        for (int i = 0; i < Integer.parseInt(totalChunks); ++i) {
            String chunkFileName = UploadFileChunksUtils.getFileChunkTempPath(tempFileName, uploadId, i + "");
            File chunkFile = new File(chunkFileName);
            chunkFile.delete();
        }
    }

    public static void copyChunkFile(String oldFilePath, String tempFileName, String uploadId, String chunkNumber) {
        String chunkFileName = UploadFileChunksUtils.getFileChunkTempPath(tempFileName, uploadId, chunkNumber);
        FileUtil.mkParentDirs((String)chunkFileName);
        FileUtil.copyFile((String)oldFilePath, (String)chunkFileName, (StandardCopyOption[])new StandardCopyOption[0]);
    }

    private static String getFileChunkTempPath(String tempFileName, String uploadId, String chunkNumber) {
        return FILE_CHUNK_TEMP_PATH + uploadId + "_" + tempFileName + "_" + chunkNumber;
    }

    public static void deleteChunksByQuartz(String folder) {
        String tempFolder = FilePathConfig.SAVE_PATH + "/chunks/temp/" + folder;
        if (FileUtil.exist((String)tempFolder)) {
            FileUtil.del((String)tempFolder);
        }
    }
}

