/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator;

import com.kg.component.generator.config.DataSourceConfig;
import com.kg.component.generator.config.GlobalConfig;
import com.kg.component.generator.config.InjectionConfig;
import com.kg.component.generator.config.PackageConfig;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.TemplateConfig;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.engine.AbstractTemplateEngine;
import com.kg.component.generator.engine.FreemarkerTemplateEngine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AutoGenerator.class);
    protected ConfigBuilder config;
    protected InjectionConfig injection;
    private DataSourceConfig dataSource;
    private StrategyConfig strategy;
    private PackageConfig packageInfo;
    private TemplateConfig template;
    private GlobalConfig globalConfig;

    private AutoGenerator() {
    }

    public AutoGenerator(@NotNull DataSourceConfig dataSourceConfig) {
        this.dataSource = dataSourceConfig;
    }

    public AutoGenerator injection(@NotNull InjectionConfig injectionConfig) {
        this.injection = injectionConfig;
        return this;
    }

    public AutoGenerator strategy(@NotNull StrategyConfig strategyConfig) {
        this.strategy = strategyConfig;
        return this;
    }

    public AutoGenerator packageInfo(@NotNull PackageConfig packageConfig) {
        this.packageInfo = packageConfig;
        return this;
    }

    public AutoGenerator template(@NotNull TemplateConfig templateConfig) {
        this.template = templateConfig;
        return this;
    }

    public AutoGenerator global(@NotNull GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public AutoGenerator config(@NotNull ConfigBuilder configBuilder) {
        this.config = configBuilder;
        return this;
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(AbstractTemplateEngine templateEngine) {
        logger.debug("==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        if (null == this.config) {
            this.config = new ConfigBuilder(this.packageInfo, this.dataSource, this.strategy, this.template, this.globalConfig, this.injection);
        }
        if (null == templateEngine) {
            templateEngine = new FreemarkerTemplateEngine();
        }
        templateEngine.setConfigBuilder(this.config);
        templateEngine.init(this.config).batchOutput().open();
        logger.debug("==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
    }

    @NotNull
    protected List<TableInfo> getAllTableInfoList(@NotNull ConfigBuilder config) {
        return config.getTableInfoList();
    }

    public ConfigBuilder getConfig() {
        return this.config;
    }

    public InjectionConfig getInjectionConfig() {
        return this.injection;
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public StrategyConfig getStrategy() {
        return this.strategy;
    }

    public PackageConfig getPackageInfo() {
        return this.packageInfo;
    }

    public TemplateConfig getTemplate() {
        return this.template;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

