/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.AutoGenerator;
import com.kg.component.generator.config.DataSourceConfig;
import com.kg.component.generator.config.GlobalConfig;
import com.kg.component.generator.config.InjectionConfig;
import com.kg.component.generator.config.PackageConfig;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.TemplateConfig;
import com.kg.component.generator.engine.AbstractTemplateEngine;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class FastAutoGenerator {
    private final DataSourceConfig.Builder dataSourceConfigBuilder;
    private final GlobalConfig.Builder globalConfigBuilder;
    private final PackageConfig.Builder packageConfigBuilder;
    private final StrategyConfig.Builder strategyConfigBuilder;
    private final InjectionConfig.Builder injectionConfigBuilder;
    private final TemplateConfig.Builder templateConfigBuilder;
    private AbstractTemplateEngine templateEngine;
    private final Scanner scanner = new Scanner(System.in);

    private FastAutoGenerator(DataSourceConfig.Builder dataSourceConfigBuilder) {
        this.dataSourceConfigBuilder = dataSourceConfigBuilder;
        this.globalConfigBuilder = new GlobalConfig.Builder();
        this.packageConfigBuilder = new PackageConfig.Builder();
        this.strategyConfigBuilder = new StrategyConfig.Builder();
        this.injectionConfigBuilder = new InjectionConfig.Builder();
        this.templateConfigBuilder = new TemplateConfig.Builder();
    }

    public static FastAutoGenerator create(@NotNull String url, String username, String password) {
        return new FastAutoGenerator(new DataSourceConfig.Builder(url, username, password));
    }

    public static FastAutoGenerator create(@NotNull DataSourceConfig.Builder dataSourceConfigBuilder) {
        return new FastAutoGenerator(dataSourceConfigBuilder);
    }

    public String scannerNext(String message) {
        System.out.println(message);
        String nextLine = this.scanner.nextLine();
        if (StringUtils.isBlank((CharSequence)nextLine)) {
            return this.scanner.next();
        }
        return nextLine;
    }

    public FastAutoGenerator globalConfig(Consumer<GlobalConfig.Builder> consumer) {
        consumer.accept(this.globalConfigBuilder);
        return this;
    }

    public FastAutoGenerator globalConfig(BiConsumer<Function<String, String>, GlobalConfig.Builder> biConsumer) {
        biConsumer.accept(message -> this.scannerNext((String)message), this.globalConfigBuilder);
        return this;
    }

    public FastAutoGenerator packageConfig(Consumer<PackageConfig.Builder> consumer) {
        consumer.accept(this.packageConfigBuilder);
        return this;
    }

    public FastAutoGenerator packageConfig(BiConsumer<Function<String, String>, PackageConfig.Builder> biConsumer) {
        biConsumer.accept(message -> this.scannerNext((String)message), this.packageConfigBuilder);
        return this;
    }

    public FastAutoGenerator strategyConfig(Consumer<StrategyConfig.Builder> consumer) {
        consumer.accept(this.strategyConfigBuilder);
        return this;
    }

    public FastAutoGenerator strategyConfig(BiConsumer<Function<String, String>, StrategyConfig.Builder> biConsumer) {
        biConsumer.accept(message -> this.scannerNext((String)message), this.strategyConfigBuilder);
        return this;
    }

    public FastAutoGenerator injectionConfig(Consumer<InjectionConfig.Builder> consumer) {
        consumer.accept(this.injectionConfigBuilder);
        return this;
    }

    public FastAutoGenerator injectionConfig(BiConsumer<Function<String, String>, InjectionConfig.Builder> biConsumer) {
        biConsumer.accept(message -> this.scannerNext((String)message), this.injectionConfigBuilder);
        return this;
    }

    public FastAutoGenerator templateConfig(Consumer<TemplateConfig.Builder> consumer) {
        consumer.accept(this.templateConfigBuilder);
        return this;
    }

    public FastAutoGenerator templateConfig(BiConsumer<Function<String, String>, TemplateConfig.Builder> biConsumer) {
        biConsumer.accept(message -> this.scannerNext((String)message), this.templateConfigBuilder);
        return this;
    }

    public FastAutoGenerator templateEngine(AbstractTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public void execute() {
        new AutoGenerator(this.dataSourceConfigBuilder.build()).global(this.globalConfigBuilder.build()).packageInfo(this.packageConfigBuilder.build()).strategy(this.strategyConfigBuilder.build()).injection(this.injectionConfigBuilder.build()).template(this.templateConfigBuilder.build()).execute(this.templateEngine);
    }
}

