/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.config.IConfigBuilder;
import com.kg.component.generator.config.TemplateType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateConfig.class);
    private String entity = "/templates/entity.java";
    private String entityKt = "/templates/entity.kt";
    private String dto = "/templates/dto.java";
    private String dtoconvert = "/templates/dtoconvert.java";
    private String excelConstant = "/templates/excelconstant.java";
    private String excelOut = "/templates/excelout.java";
    private String controller = "/templates/controller.java";
    private String indexVue = "/templates/index.vue";
    private String permissionSQL = "/templates/permission.sql";
    private String mapper = "/templates/mapper.java";
    private String xml = "/templates/mapper.xml";
    private String service = "/templates/service.java";
    private String serviceImpl = "/templates/serviceImpl.java";
    private boolean disableEntity;

    private TemplateConfig() {
    }

    private void logger(String value, TemplateType templateType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("\u63a8\u8350\u4f7f\u7528disable(TemplateType.{})\u65b9\u6cd5\u8fdb\u884c\u9ed8\u8ba4\u6a21\u677f\u7981\u7528.", (Object)templateType.name());
        }
    }

    public String getEntity(boolean kotlin) {
        if (!this.disableEntity) {
            if (kotlin) {
                return StringUtils.isBlank((CharSequence)this.entityKt) ? "/templates/entity.kt" : this.entityKt;
            }
            return StringUtils.isBlank((CharSequence)this.entity) ? "/templates/entity.java" : this.entity;
        }
        return null;
    }

    public TemplateConfig disable(TemplateType ... templateTypes) {
        if (templateTypes != null && templateTypes.length > 0) {
            block14: for (TemplateType templateType : templateTypes) {
                switch (templateType) {
                    case ENTITY: {
                        this.entity = null;
                        this.entityKt = null;
                        this.disableEntity = true;
                        continue block14;
                    }
                    case DTO: {
                        this.dto = null;
                        continue block14;
                    }
                    case DTOCONVERT: {
                        this.dtoconvert = null;
                        continue block14;
                    }
                    case EXCEL_CONSTANT: {
                        this.excelConstant = null;
                        continue block14;
                    }
                    case EXCEL_OUT: {
                        this.excelOut = null;
                        continue block14;
                    }
                    case CONTROLLER: {
                        this.controller = null;
                        continue block14;
                    }
                    case INDEXVUE: {
                        this.indexVue = null;
                        continue block14;
                    }
                    case PERMISSIONSQL: {
                        this.permissionSQL = null;
                        continue block14;
                    }
                    case MAPPER: {
                        this.mapper = null;
                        continue block14;
                    }
                    case XML: {
                        this.xml = null;
                        continue block14;
                    }
                    case SERVICE: {
                        this.service = null;
                        continue block14;
                    }
                    case SERVICE_IMPL: {
                        this.serviceImpl = null;
                        continue block14;
                    }
                }
            }
        }
        return this;
    }

    public TemplateConfig disable() {
        return this.disable(TemplateType.values());
    }

    public String getService() {
        return this.service;
    }

    public String getServiceImpl() {
        return this.serviceImpl;
    }

    public String getMapper() {
        return this.mapper;
    }

    public String getDTO() {
        return this.dto;
    }

    public String getDtoconvert() {
        return this.dtoconvert;
    }

    public String getExcelConstant() {
        return this.excelConstant;
    }

    public String getExcelOut() {
        return this.excelOut;
    }

    public String getXml() {
        return this.xml;
    }

    public String getController() {
        return this.controller;
    }

    public String getIndexVue() {
        return this.indexVue;
    }

    public String getPermissionSQL() {
        return this.permissionSQL;
    }

    public static class Builder
    implements IConfigBuilder<TemplateConfig> {
        private final TemplateConfig templateConfig = new TemplateConfig();

        public Builder disable() {
            this.templateConfig.disable();
            return this;
        }

        public Builder disable(TemplateType ... templateTypes) {
            this.templateConfig.disable(templateTypes);
            return this;
        }

        public Builder entity(@NotNull String entityTemplate) {
            this.templateConfig.disableEntity = false;
            this.templateConfig.entity = entityTemplate;
            return this;
        }

        public Builder entityKt(@NotNull String entityKtTemplate) {
            this.templateConfig.disableEntity = false;
            this.templateConfig.entityKt = entityKtTemplate;
            return this;
        }

        public Builder service(@NotNull String serviceTemplate) {
            this.templateConfig.service = serviceTemplate;
            return this;
        }

        public Builder serviceImpl(@NotNull String serviceImplTemplate) {
            this.templateConfig.serviceImpl = serviceImplTemplate;
            return this;
        }

        public Builder mapper(@NotNull String mapperTemplate) {
            this.templateConfig.mapper = mapperTemplate;
            return this;
        }

        public Builder xml(@NotNull String xmlTemplate) {
            this.templateConfig.xml = xmlTemplate;
            return this;
        }

        public Builder controller(@NotNull String controllerTemplate) {
            this.templateConfig.controller = controllerTemplate;
            return this;
        }

        public Builder DTO(@NotNull String dtoTemplate) {
            this.templateConfig.dto = dtoTemplate;
            return this;
        }

        public Builder excelConstant(@NotNull String excelConstantTemplate) {
            this.templateConfig.excelConstant = excelConstantTemplate;
            return this;
        }

        public Builder excelOut(@NotNull String excelOutTemplate) {
            this.templateConfig.excelOut = excelOutTemplate;
            return this;
        }

        public Builder indexVue(@NotNull String indexVueTemplate) {
            this.templateConfig.indexVue = indexVueTemplate;
            return this;
        }

        @Override
        public TemplateConfig build() {
            return this.templateConfig;
        }
    }
}

