/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.ITemplate;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.BaseBuilder;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.function.ConverterFileName;
import com.kg.component.generator.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private boolean restStyle;
    private boolean hyphenStyle;
    private String superClass;
    private ConverterFileName converterFileName = entityName -> entityName + "Controller";
    private boolean fileOverride;

    private Controller() {
    }

    public boolean isRestStyle() {
        return this.restStyle;
    }

    public boolean isHyphenStyle() {
        return this.hyphenStyle;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    @NotNull
    public ConverterFileName getConverterFileName() {
        return this.converterFileName;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        String packageStr = config.getPackageConfig().getModuleName();
        if (StringUtils.isNotBlank((CharSequence)packageStr)) {
            data.put("controllerMapping", packageStr.replaceAll("\\.", "/") + "/" + (this.hyphenStyle ? StringUtils.camelToHyphen((String)tableInfo.getEntityPath()) : tableInfo.getEntityPath()));
            data.put("controllerAuthorizePre", packageStr.replaceAll("\\.", ":") + ":" + (this.hyphenStyle ? StringUtils.camelToHyphen((String)tableInfo.getEntityPath()) : tableInfo.getEntityPath()) + ":");
        } else {
            data.put("controllerMapping", this.hyphenStyle ? StringUtils.camelToHyphen((String)tableInfo.getEntityPath()) : tableInfo.getEntityPath());
            data.put("controllerAuthorizePre", (this.hyphenStyle ? StringUtils.camelToHyphen((String)tableInfo.getEntityPath()) : tableInfo.getEntityPath()) + ":");
        }
        data.put("restControllerStyle", this.restStyle);
        data.put("superControllerClassPackage", StringUtils.isBlank((CharSequence)this.superClass) ? null : this.superClass);
        data.put("superControllerClass", ClassUtils.getSimpleName(this.superClass));
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final Controller controller = new Controller();

        public Builder(@NotNull StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superClass(@NotNull Class<?> clazz) {
            return this.superClass(clazz.getName());
        }

        public Builder superClass(@NotNull String superClass) {
            this.controller.superClass = superClass;
            return this;
        }

        public Builder enableHyphenStyle() {
            this.controller.hyphenStyle = true;
            return this;
        }

        public Builder enableRestStyle() {
            this.controller.restStyle = true;
            return this;
        }

        public Builder convertFileName(@NotNull ConverterFileName converter) {
            this.controller.converterFileName = converter;
            return this;
        }

        public Builder formatFileName(@NotNull String format) {
            return this.convertFileName(entityName -> String.format(format, entityName));
        }

        public Builder enableFileOverride() {
            this.controller.fileOverride = true;
            return this;
        }

        @NotNull
        public Controller get() {
            return this.controller;
        }
    }
}

