/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.builder;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.IFill;
import com.kg.component.generator.ITemplate;
import com.kg.component.generator.config.INameConvert;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.BaseBuilder;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.config.rules.NamingStrategy;
import com.kg.component.generator.function.ConverterFileName;
import com.kg.component.generator.util.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTO
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DTO.class);
    private INameConvert nameConvert;
    private String superClass;
    private List<String> childTableList;
    private final Set<String> superDTOColumns = new HashSet<String>();
    private final Set<String> ignoreColumns = new HashSet<String>();
    private boolean serialVersionUID = true;
    private boolean columnConstant;
    private boolean chain;
    private boolean lombok;
    private boolean booleanColumnRemoveIsPrefix;
    private boolean tableFieldAnnotationEnable;
    private String versionColumnName;
    private String versionPropertyName;
    private String logicDeleteColumnName;
    private String logicDeletePropertyName;
    private final List<IFill> tableFillList = new ArrayList<IFill>();
    private NamingStrategy naming = NamingStrategy.underline_to_camel;
    private NamingStrategy columnNaming = null;
    private boolean activeRecord;
    private IdType idType;
    private ConverterFileName converterFileName = entityName -> entityName + "DTO";
    private ConverterFileName dtoconverterFileName = entityName -> entityName + "Convert";
    private boolean fileOverride;

    private DTO() {
    }

    public void convertSuperDTOColumns(Class<?> clazz) {
        if (clazz.isInterface()) {
            return;
        }
        List fields = TableInfoHelper.getAllFields(clazz);
        this.superDTOColumns.addAll(fields.stream().map(field -> {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId != null && StringUtils.isNotBlank((CharSequence)tableId.value())) {
                return tableId.value();
            }
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null && StringUtils.isNotBlank((CharSequence)tableField.value())) {
                return tableField.value();
            }
            if (null == this.columnNaming || this.columnNaming == NamingStrategy.no_change) {
                return field.getName();
            }
            return StringUtils.camelToUnderline((String)field.getName());
        }).collect(Collectors.toSet()));
    }

    @NotNull
    public NamingStrategy getColumnNaming() {
        return Optional.ofNullable(this.columnNaming).orElse(this.naming);
    }

    public boolean matchSuperDTOColumns(String fieldName) {
        return this.superDTOColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    public boolean matchIgnoreColumns(String fieldName) {
        return this.ignoreColumns.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName));
    }

    @NotNull
    public INameConvert getNameConvert() {
        return this.nameConvert;
    }

    @Nullable
    public String getSuperClass() {
        return this.superClass;
    }

    public List<String> getChildTableList() {
        return this.childTableList;
    }

    public Set<String> getSuperDTOColumns() {
        return this.superDTOColumns;
    }

    public boolean isSerialVersionUID() {
        return this.serialVersionUID;
    }

    public boolean isColumnConstant() {
        return this.columnConstant;
    }

    public boolean isChain() {
        return this.chain;
    }

    public boolean isLombok() {
        return this.lombok;
    }

    public boolean isBooleanColumnRemoveIsPrefix() {
        return this.booleanColumnRemoveIsPrefix;
    }

    public boolean isTableFieldAnnotationEnable() {
        return this.tableFieldAnnotationEnable;
    }

    @Nullable
    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    @Nullable
    public String getVersionPropertyName() {
        return this.versionPropertyName;
    }

    @Nullable
    public String getLogicDeleteColumnName() {
        return this.logicDeleteColumnName;
    }

    @Nullable
    public String getLogicDeletePropertyName() {
        return this.logicDeletePropertyName;
    }

    @NotNull
    public List<IFill> getTableFillList() {
        return this.tableFillList;
    }

    @NotNull
    public NamingStrategy getNaming() {
        return this.naming;
    }

    public boolean isActiveRecord() {
        return this.activeRecord;
    }

    @Nullable
    public IdType getIdType() {
        return this.idType;
    }

    @NotNull
    public ConverterFileName getConverterFileName() {
        return this.converterFileName;
    }

    @NotNull
    public ConverterFileName getConverterDtoconvertFileName() {
        return this.dtoconverterFileName;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("activeRecord", this.activeRecord);
        data.put("dtoSerialVersionUID", this.serialVersionUID);
        data.put("dtoColumnConstant", this.columnConstant);
        data.put("chainModel", this.chain);
        data.put("dtoLombokModel", this.lombok);
        data.put("superDTOClassPackage", StringUtils.isBlank((CharSequence)this.superClass) ? null : this.superClass);
        data.put("superDTOClass", ClassUtils.getSimpleName(this.superClass));
        if (this.childTableList != null && this.childTableList.size() > 0) {
            data.put("childTableList", this.childTableList);
            data.put("packageBaseParent", config.getPackageConfig().getBaseParent());
        }
        data.put("dtoName", tableInfo.getDTOName());
        data.put("dtoconvertName", tableInfo.getDtoconvertName());
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final DTO dto = new DTO();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
            this.dto.nameConvert = new INameConvert.DefaultNameConvert(strategyConfig);
        }

        public Builder nameConvert(INameConvert nameConvert) {
            this.dto.nameConvert = nameConvert;
            return this;
        }

        public Builder superClass(@NotNull Class<?> clazz) {
            return this.superClass(clazz.getName());
        }

        public Builder superClass(String superDTOClass) {
            this.dto.superClass = superDTOClass;
            return this;
        }

        public Builder childTableList(List<String> childTableList) {
            this.dto.childTableList = childTableList;
            return this;
        }

        public Builder disableSerialVersionUID() {
            this.dto.serialVersionUID = false;
            return this;
        }

        public Builder enableColumnConstant() {
            this.dto.columnConstant = true;
            return this;
        }

        public Builder enableChainModel() {
            this.dto.chain = true;
            return this;
        }

        public Builder enableLombok() {
            this.dto.lombok = true;
            return this;
        }

        public Builder enableRemoveIsPrefix() {
            this.dto.booleanColumnRemoveIsPrefix = true;
            return this;
        }

        public Builder enableTableFieldAnnotation() {
            this.dto.tableFieldAnnotationEnable = true;
            return this;
        }

        public Builder enableActiveRecord() {
            this.dto.activeRecord = true;
            return this;
        }

        public Builder versionColumnName(String versionColumnName) {
            this.dto.versionColumnName = versionColumnName;
            return this;
        }

        public Builder versionPropertyName(String versionPropertyName) {
            this.dto.versionPropertyName = versionPropertyName;
            return this;
        }

        public Builder logicDeleteColumnName(String logicDeleteColumnName) {
            this.dto.logicDeleteColumnName = logicDeleteColumnName;
            return this;
        }

        public Builder logicDeletePropertyName(String logicDeletePropertyName) {
            this.dto.logicDeletePropertyName = logicDeletePropertyName;
            return this;
        }

        public Builder naming(NamingStrategy namingStrategy) {
            this.dto.naming = namingStrategy;
            return this;
        }

        public Builder columnNaming(NamingStrategy namingStrategy) {
            this.dto.columnNaming = namingStrategy;
            return this;
        }

        public Builder addSuperDTOColumns(String ... superDTOColumns) {
            return this.addSuperDTOColumns(Arrays.asList(superDTOColumns));
        }

        public Builder addSuperDTOColumns(@NotNull List<String> superDTOColumnList) {
            this.dto.superDTOColumns.addAll(superDTOColumnList);
            return this;
        }

        public Builder addIgnoreColumns(String ... ignoreColumns) {
            return this.addIgnoreColumns(Arrays.asList(ignoreColumns));
        }

        public Builder addIgnoreColumns(@NotNull List<String> ignoreColumnList) {
            this.dto.ignoreColumns.addAll(ignoreColumnList);
            return this;
        }

        public Builder addTableFills(IFill ... tableFills) {
            return this.addTableFills(Arrays.asList(tableFills));
        }

        public Builder addTableFills(@NotNull List<IFill> tableFillList) {
            this.dto.tableFillList.addAll(tableFillList);
            return this;
        }

        public Builder idType(IdType idType) {
            this.dto.idType = idType;
            return this;
        }

        public Builder convertFileName(@NotNull ConverterFileName converter) {
            this.dto.converterFileName = converter;
            return this;
        }

        public Builder formatFileName(String format) {
            return this.convertFileName(dtoName -> String.format(format, dtoName));
        }

        public Builder enableFileOverride() {
            this.dto.fileOverride = true;
            return this;
        }

        public DTO get() {
            String superClass = this.dto.superClass;
            if (StringUtils.isNotBlank((CharSequence)superClass)) {
                this.tryLoadClass(superClass).ifPresent(this.dto::convertSuperDTOColumns);
            } else if (!this.dto.superDTOColumns.isEmpty()) {
                LOGGER.warn("Forgot to set dto supper class ?");
            }
            return this.dto;
        }

        private Optional<Class<?>> tryLoadClass(String className) {
            try {
                return Optional.of(ClassUtils.toClassConfident(className));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }
}

