/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.ITemplate;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.BaseBuilder;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexVue
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexVue.class);
    private String viewPath;
    private boolean fileOverride;
    private String templateHtml;
    private String jsData;
    private String jsCreated;
    private String jsMethods;
    private String templateCss;

    private IndexVue() {
    }

    public String getViewPath() {
        return this.viewPath;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public String getTemplateHtml() {
        return this.templateHtml;
    }

    public String getJsData() {
        return this.jsData;
    }

    public String getJsCreated() {
        return this.jsCreated;
    }

    public String getJsMethods() {
        return this.jsMethods;
    }

    public String getTemplateCss() {
        return this.templateCss;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>(7);
        String packageStr = config.getPackageConfig().getModuleName();
        if (StringUtils.isNotBlank((CharSequence)packageStr)) {
            data.put("controllerMapping", packageStr.replaceAll("\\.", "/") + "/" + tableInfo.getEntityPath());
            data.put("buttonNamePre", packageStr.replaceAll("\\.", "-") + "-" + tableInfo.getEntityPath() + "-");
        } else {
            data.put("controllerMapping", tableInfo.getEntityPath());
            data.put("buttonNamePre", tableInfo.getEntityPath() + "-");
        }
        data.put("templateHtml", this.getTemplateHtml());
        data.put("jsData", this.getJsData());
        data.put("jsCreated", this.getJsCreated());
        data.put("jsMethods", this.getJsMethods());
        data.put("templateCss", this.getTemplateCss());
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final IndexVue indexVue = new IndexVue();

        public Builder(@NotNull StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder viewPath(String viewPath) {
            this.indexVue.viewPath = viewPath;
            return this;
        }

        public Builder templateHtml(String templateHtml) {
            this.indexVue.templateHtml = templateHtml;
            return this;
        }

        public Builder jsData(String jsData) {
            this.indexVue.jsData = jsData;
            return this;
        }

        public Builder jsCreated(String jsCreated) {
            this.indexVue.jsCreated = jsCreated;
            return this;
        }

        public Builder jsMethods(String jsMethods) {
            this.indexVue.jsMethods = jsMethods;
            return this;
        }

        public Builder templateCss(String templateCss) {
            this.indexVue.templateCss = templateCss;
            return this;
        }

        public Builder enableFileOverride() {
            this.indexVue.fileOverride = true;
            return this;
        }

        @NotNull
        public IndexVue get() {
            return this.indexVue;
        }
    }
}

