/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.ITemplate;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.BaseBuilder;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.utils.GuidUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionSQL
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionSQL.class);
    private boolean fileOverride;

    private PermissionSQL() {
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String packageStr = config.getPackageConfig().getModuleName();
        if (StringUtils.isNotBlank((CharSequence)packageStr)) {
            data.put("controllerMapping", "/" + packageStr.replaceAll("\\.", "/") + "/" + tableInfo.getEntityPath());
            data.put("controllerAuthorizePre", packageStr.replaceAll("\\.", ":") + ":" + tableInfo.getEntityPath() + ":");
            data.put("permissionName", packageStr.replaceAll("\\.", "-") + "-" + tableInfo.getEntityPath());
        } else {
            data.put("controllerMapping", "/" + tableInfo.getEntityPath());
            data.put("controllerAuthorizePre", tableInfo.getEntityPath() + ":");
            data.put("permissionName", tableInfo.getEntityPath());
        }
        String permissionRouter = config.getStrategyConfig().indexVue().getViewPath();
        data.put("permissionRouter", permissionRouter);
        data.put("permissionCompontent", permissionRouter + "/index");
        data.put("menuId", GuidUtils.getUuid());
        data.put("addBtnId", GuidUtils.getUuid());
        data.put("updateBtnId", GuidUtils.getUuid());
        data.put("deleteBtnId", GuidUtils.getUuid());
        data.put("exportExcelBtnId", GuidUtils.getUuid());
        data.put("importExcelBtnId", GuidUtils.getUuid());
        data.put("addApiId", GuidUtils.getUuid());
        data.put("updateApiId", GuidUtils.getUuid());
        data.put("deleteApiId", GuidUtils.getUuid());
        data.put("exportExcelApiId", GuidUtils.getUuid());
        data.put("importExcelApiId", GuidUtils.getUuid());
        data.put("listApiId", GuidUtils.getUuid());
        data.put("getByIdApiId", GuidUtils.getUuid());
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final PermissionSQL permissionSQL = new PermissionSQL();

        public Builder(@NotNull StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder enableFileOverride() {
            this.permissionSQL.fileOverride = true;
            return this;
        }

        @NotNull
        public PermissionSQL get() {
            return this.permissionSQL;
        }
    }
}

