/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.converts;

import com.kg.component.generator.config.GlobalConfig;
import com.kg.component.generator.config.ITypeConvert;
import com.kg.component.generator.config.converts.TypeConverts;
import com.kg.component.generator.config.rules.DbColumnType;
import com.kg.component.generator.config.rules.IColumnType;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ClickHouseTypeConvert
implements ITypeConvert {
    public static final ClickHouseTypeConvert INSTANCE = new ClickHouseTypeConvert();
    static final String[] INTEGER_TYPE = new String[]{"intervalyear", "intervalquarter", "intervalmonth", "intervalweek", "intervalday", "intervalhour", "intervalminute", "intervalsecond", "uint16", "uint8", "int16", "int8", "int32"};
    static final String[] BIGINTEGER_TYPE = new String[]{"uint256", "uint128", "uint64", "int256", "int128"};
    static final String[] BIGDECIMAL_TYPE = new String[]{"decimal32", "decimal64", "decimal128", "decimal256", "decimal"};
    static final String[] LONG_TYPE = new String[]{"int64", "uint32"};
    static final String[] STRING_TYPE = new String[]{"uuid", "char", "varchar", "text", "tinytext", "longtext", "blob", "tinyblob", "mediumblob", "longblob", "enum8", "enum16", "ipv4", "ipv6", "string", "fixedstring", "nothing", "nested", "tuple", "aggregatefunction", "unknown"};

    @Override
    public IColumnType processTypeConvert(@NotNull GlobalConfig globalConfig, @NotNull String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny(INTEGER_TYPE).then(DbColumnType.INTEGER)).test(TypeConverts.containsAny(BIGINTEGER_TYPE).then(DbColumnType.BIG_INTEGER)).test(TypeConverts.containsAny(BIGDECIMAL_TYPE).then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.containsAny(LONG_TYPE).then(DbColumnType.LONG)).test(TypeConverts.contains("float32").then(DbColumnType.FLOAT)).test(TypeConverts.contains("float64").then(DbColumnType.DOUBLE)).test(TypeConverts.contains("map").then(DbColumnType.MAP)).test(TypeConverts.contains("array").then(DbColumnType.OBJECT)).test(TypeConverts.containsAny("date", "datetime", "datetime64").then((IColumnType)((Object)((Function<String, IColumnType>)t -> ClickHouseTypeConvert.toDateType(globalConfig, fieldType))))).test(TypeConverts.containsAny(STRING_TYPE).then(DbColumnType.STRING)).or(DbColumnType.STRING);
    }

    public static IColumnType toDateType(GlobalConfig config, String type) {
        switch (config.getDateType()) {
            case SQL_PACK: {
                if ("date".equals(type)) {
                    return DbColumnType.DATE_SQL;
                }
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                if ("date".equals(type)) {
                    return DbColumnType.LOCAL_DATE;
                }
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.DATE;
    }
}

