/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.config.GlobalConfig;
import com.kg.component.generator.config.OutputFile;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.TemplateConfig;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.builder.CustomFile;
import com.kg.component.generator.config.po.TableField;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.util.FileUtils;
import com.kg.component.generator.util.RuntimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTemplateEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConfigBuilder configBuilder;

    @NotNull
    public abstract AbstractTemplateEngine init(@NotNull ConfigBuilder var1);

    protected void outputCustomFile(@NotNull List<CustomFile> customFiles, @NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String parentPath = this.getPathInfo(OutputFile.parent);
        customFiles.forEach(file -> {
            String filePath;
            String string = filePath = StringUtils.isNotBlank((CharSequence)file.getFilePath()) ? file.getFilePath() : parentPath;
            if (StringUtils.isNotBlank((CharSequence)file.getPackageName())) {
                filePath = filePath + File.separator + file.getPackageName();
                filePath = filePath.replaceAll("\\.", "\\" + File.separator);
            }
            String fileName = filePath + File.separator + entityName + file.getFileName();
            this.outputFile(new File(fileName), objectMap, file.getTemplatePath(), file.isFileOverride());
        });
    }

    protected void outputEntity(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String entityPath = this.getPathInfo(OutputFile.entity);
        if (StringUtils.isNotBlank((CharSequence)entityName) && StringUtils.isNotBlank((CharSequence)entityPath)) {
            this.getTemplateFilePath(template -> template.getEntity(this.getConfigBuilder().getGlobalConfig().isKotlin())).ifPresent(entity -> {
                String entityFile = String.format(entityPath + File.separator + "%s" + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(entityFile), objectMap, (String)entity, this.getConfigBuilder().getStrategyConfig().entity().isFileOverride());
            });
        }
    }

    protected void outputDTO(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String dtoPath = this.getPathInfo(OutputFile.dto);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getDTOName()) && StringUtils.isNotBlank((CharSequence)dtoPath)) {
            this.getTemplateFilePath(TemplateConfig::getDTO).ifPresent(dto -> {
                String dtoFile = String.format(dtoPath + File.separator + tableInfo.getDTOName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(dtoFile), objectMap, (String)dto, this.getConfigBuilder().getStrategyConfig().dto().isFileOverride());
            });
        }
        String dtoconvertPath = this.getPathInfo(OutputFile.convert);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getDtoconvertName()) && StringUtils.isNotBlank((CharSequence)dtoconvertPath)) {
            this.getTemplateFilePath(TemplateConfig::getDtoconvert).ifPresent(convert -> {
                String dtoconvertFile = String.format(dtoconvertPath + File.separator + tableInfo.getDtoconvertName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(dtoconvertFile), objectMap, (String)convert, this.getConfigBuilder().getStrategyConfig().dto().isFileOverride());
            });
        }
    }

    protected void outputExcels(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String excelOutPath;
        String entityName = tableInfo.getEntityName();
        String excelConstantPath = this.getPathInfo(OutputFile.excelConstant);
        if (StringUtils.isNotBlank((CharSequence)excelConstantPath)) {
            this.getTemplateFilePath(TemplateConfig::getExcelConstant).ifPresent(constant -> {
                String excelConstantFile = excelConstantPath + File.separator + entityName + "ExcelConstant" + this.suffixJavaOrKt();
                this.outputFile(new File(excelConstantFile), objectMap, (String)constant, this.getConfigBuilder().getStrategyConfig().excels().isFileOverride());
            });
        }
        if (StringUtils.isNotBlank((CharSequence)(excelOutPath = this.getPathInfo(OutputFile.excelOut)))) {
            this.getTemplateFilePath(TemplateConfig::getExcelOut).ifPresent(out -> {
                String excelOutFile = excelOutPath + File.separator + entityName + "ExcelOutDTO" + this.suffixJavaOrKt();
                this.outputFile(new File(excelOutFile), objectMap, (String)out, this.getConfigBuilder().getStrategyConfig().excels().isFileOverride());
            });
        }
    }

    protected void outputMapper(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String mapperPath = this.getPathInfo(OutputFile.mapper);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getMapperName()) && StringUtils.isNotBlank((CharSequence)mapperPath)) {
            this.getTemplateFilePath(TemplateConfig::getMapper).ifPresent(mapper -> {
                String mapperFile = String.format(mapperPath + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(mapperFile), objectMap, (String)mapper, this.getConfigBuilder().getStrategyConfig().mapper().isFileOverride());
            });
        }
        String xmlPath = this.getPathInfo(OutputFile.xml);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getXmlName()) && StringUtils.isNotBlank((CharSequence)xmlPath)) {
            this.getTemplateFilePath(TemplateConfig::getXml).ifPresent(xml -> {
                String xmlFile = String.format(xmlPath + File.separator + tableInfo.getXmlName() + ".xml", entityName);
                this.outputFile(new File(xmlFile), objectMap, (String)xml, this.getConfigBuilder().getStrategyConfig().mapper().isFileOverride());
            });
        }
    }

    protected void outputService(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String entityName = tableInfo.getEntityName();
        String servicePath = this.getPathInfo(OutputFile.service);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getServiceName()) && StringUtils.isNotBlank((CharSequence)servicePath)) {
            this.getTemplateFilePath(TemplateConfig::getService).ifPresent(service -> {
                String serviceFile = String.format(servicePath + File.separator + tableInfo.getServiceName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(serviceFile), objectMap, (String)service, this.getConfigBuilder().getStrategyConfig().service().isFileOverride());
            });
        }
        String serviceImplPath = this.getPathInfo(OutputFile.serviceImpl);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getServiceImplName()) && StringUtils.isNotBlank((CharSequence)serviceImplPath)) {
            this.getTemplateFilePath(TemplateConfig::getServiceImpl).ifPresent(serviceImpl -> {
                String implFile = String.format(serviceImplPath + File.separator + tableInfo.getServiceImplName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(implFile), objectMap, (String)serviceImpl, this.getConfigBuilder().getStrategyConfig().service().isFileOverride());
            });
        }
    }

    protected void outputController(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String controllerPath = this.getPathInfo(OutputFile.controller);
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getControllerName()) && StringUtils.isNotBlank((CharSequence)controllerPath)) {
            this.getTemplateFilePath(TemplateConfig::getController).ifPresent(controller -> {
                String entityName = tableInfo.getEntityName();
                String controllerFile = String.format(controllerPath + File.separator + tableInfo.getControllerName() + this.suffixJavaOrKt(), entityName);
                this.outputFile(new File(controllerFile), objectMap, (String)controller, this.getConfigBuilder().getStrategyConfig().controller().isFileOverride());
            });
        }
    }

    protected void outputIndexVue(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String indexVuePath = this.getPathInfo(OutputFile.indexVue);
        if (StringUtils.isNotBlank((CharSequence)indexVuePath)) {
            this.getTemplateFilePath(TemplateConfig::getIndexVue).ifPresent(indexVue -> {
                String indexVueFile = indexVuePath + File.separator + objectMap.get("indexVuePackage") + File.separator + "index" + ".vue";
                this.outputFile(new File(indexVueFile), objectMap, (String)indexVue, this.getConfigBuilder().getStrategyConfig().indexVue().isFileOverride());
            });
        }
    }

    protected void outputPermissionSQL(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
        String permissionSQLPath = this.getPathInfo(OutputFile.permissionSql);
        if (StringUtils.isNotBlank((CharSequence)permissionSQLPath)) {
            this.getTemplateFilePath(TemplateConfig::getPermissionSQL).ifPresent(permissionSQL -> {
                String entityName = tableInfo.getEntityName();
                String permissionSQLFile = permissionSQLPath + File.separator + entityName + "-permission" + ".sql";
                this.outputFile(new File(permissionSQLFile), objectMap, (String)permissionSQL, this.getConfigBuilder().getStrategyConfig().permissionSQL().isFileOverride());
            });
        }
    }

    @Deprecated
    protected void outputFile(@NotNull File file, @NotNull Map<String, Object> objectMap, @NotNull String templatePath) {
        this.outputFile(file, objectMap, templatePath, false);
    }

    protected void outputFile(@NotNull File file, @NotNull Map<String, Object> objectMap, @NotNull String templatePath, boolean fileOverride) {
        if (this.isCreate(file, fileOverride)) {
            try {
                boolean exist = file.exists();
                if (!exist) {
                    File parentFile = file.getParentFile();
                    FileUtils.forceMkdir(parentFile);
                }
                this.writer(objectMap, templatePath, file);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @NotNull
    protected Optional<String> getTemplateFilePath(@NotNull Function<TemplateConfig, String> function) {
        TemplateConfig templateConfig = this.getConfigBuilder().getTemplateConfig();
        String filePath = function.apply(templateConfig);
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            return Optional.of(this.templateFilePath(filePath));
        }
        return Optional.empty();
    }

    @Nullable
    protected String getPathInfo(@NotNull OutputFile outputFile) {
        return this.getConfigBuilder().getPathInfo().get((Object)outputFile);
    }

    @NotNull
    public AbstractTemplateEngine batchOutput() {
        try {
            ConfigBuilder config = this.getConfigBuilder();
            List<TableInfo> tableInfoList = config.getTableInfoList();
            tableInfoList.forEach(tableInfo -> {
                Map<String, Object> objectMap = this.getObjectMap(config, (TableInfo)tableInfo);
                Optional.ofNullable(config.getInjectionConfig()).ifPresent(t -> {
                    t.beforeOutputFile((TableInfo)tableInfo, objectMap);
                    this.outputCustomFile(t.getCustomFiles(), (TableInfo)tableInfo, objectMap);
                });
                this.outputEntity((TableInfo)tableInfo, objectMap);
                this.outputDTO((TableInfo)tableInfo, objectMap);
                this.outputExcels((TableInfo)tableInfo, objectMap);
                this.outputMapper((TableInfo)tableInfo, objectMap);
                this.outputService((TableInfo)tableInfo, objectMap);
                this.outputController((TableInfo)tableInfo, objectMap);
                if (objectMap.get("permissionRouter") != null) {
                    this.outputIndexVue((TableInfo)tableInfo, objectMap);
                    this.outputPermissionSQL((TableInfo)tableInfo, objectMap);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", e);
        }
        return this;
    }

    @Deprecated
    protected void writerFile(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)templatePath)) {
            this.writer(objectMap, templatePath, outputFile);
        }
    }

    @Deprecated
    public void writer(@NotNull Map<String, Object> objectMap, @NotNull String templatePath, @NotNull String outputFile) throws Exception {
    }

    public void writer(@NotNull Map<String, Object> objectMap, @NotNull String templatePath, @NotNull File outputFile) throws Exception {
        this.writer(objectMap, templatePath, outputFile.getPath());
        this.logger.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    public void open() {
        String outDir = this.getConfigBuilder().getGlobalConfig().getOutputDir();
        if (StringUtils.isBlank((CharSequence)outDir) || !new File(outDir).exists()) {
            System.err.println("\u672a\u627e\u5230\u8f93\u51fa\u76ee\u5f55\uff1a" + outDir);
        } else if (this.getConfigBuilder().getGlobalConfig().isOpen()) {
            try {
                RuntimeUtils.openDir(outDir);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @NotNull
    public Map<String, Object> getObjectMap(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        StrategyConfig strategyConfig = config.getStrategyConfig();
        Map<String, Object> controllerData = strategyConfig.controller().renderData(config, tableInfo);
        objectMap.putAll(controllerData);
        Map<String, Object> indexVueData = strategyConfig.indexVue().renderData(config, tableInfo);
        objectMap.putAll(indexVueData);
        Map<String, Object> permissionSqlData = strategyConfig.permissionSQL().renderData(config, tableInfo);
        objectMap.putAll(permissionSqlData);
        Map<String, Object> mapperData = strategyConfig.mapper().renderData(config, tableInfo);
        objectMap.putAll(mapperData);
        Map<String, Object> serviceData = strategyConfig.service().renderData(config, tableInfo);
        objectMap.putAll(serviceData);
        Map<String, Object> entityData = strategyConfig.entity().renderData(config, tableInfo);
        objectMap.putAll(entityData);
        Map<String, Object> dtoData = strategyConfig.dto().renderData(config, tableInfo);
        objectMap.putAll(dtoData);
        Map<String, Object> excelsData = strategyConfig.excels().renderData(config, tableInfo);
        objectMap.putAll(excelsData);
        objectMap.put("config", config);
        objectMap.put("package", config.getPackageConfig().getPackageInfo());
        objectMap.put("indexVuePackage", strategyConfig.indexVue().getViewPath());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger", globalConfig.isSwagger());
        objectMap.put("springdoc", globalConfig.isSpringdoc());
        objectMap.put("date", globalConfig.getCommentDate());
        String schemaName = "";
        if (strategyConfig.isEnableSchema() && StringUtils.isNotBlank((CharSequence)(schemaName = config.getDataSourceConfig().getSchemaName()))) {
            schemaName = schemaName + ".";
            tableInfo.setConvert(true);
        }
        objectMap.put("schemaName", schemaName);
        objectMap.put("table", tableInfo);
        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("service", tableInfo.getServiceName());
        Optional<TableField> first = tableInfo.getFields().stream().filter(f -> f.isKeyFlag()).findFirst();
        if (first.isPresent()) {
            objectMap.put("entityKeyName", first.get().getPropertyName());
        }
        return objectMap;
    }

    @NotNull
    public abstract String templateFilePath(@NotNull String var1);

    @Deprecated
    protected boolean isCreate(String filePath) {
        return this.isCreate(new File(filePath));
    }

    @Deprecated
    protected boolean isCreate(@NotNull File file) {
        return !file.exists();
    }

    protected boolean isCreate(@NotNull File file, boolean fileOverride) {
        if (file.exists() && !fileOverride) {
            this.logger.warn("\u6587\u4ef6[{}]\u5df2\u5b58\u5728\uff0c\u4e14\u672a\u5f00\u542f\u6587\u4ef6\u8986\u76d6\u914d\u7f6e\uff0c\u9700\u8981\u5f00\u542f\u914d\u7f6e\u53ef\u5230\u7b56\u7565\u914d\u7f6e\u4e2d\u8bbe\u7f6e\uff01\uff01\uff01", (Object)file.getName());
        }
        return !file.exists() || fileOverride;
    }

    protected String suffixJavaOrKt() {
        return this.getConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    @NotNull
    public ConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    @NotNull
    public AbstractTemplateEngine setConfigBuilder(@NotNull ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        return this;
    }
}

