/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.query;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.builder.Entity;
import com.kg.component.generator.config.po.TableField;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.config.rules.IColumnType;
import com.kg.component.generator.jdbc.DatabaseMetaDataWrapper;
import com.kg.component.generator.query.AbstractDatabaseQuery;
import com.kg.component.generator.type.ITypeConvertHandler;
import com.kg.component.generator.type.TypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultQuery
extends AbstractDatabaseQuery {
    private final TypeRegistry typeRegistry;

    public DefaultQuery(@NotNull ConfigBuilder configBuilder) {
        super(configBuilder);
        this.typeRegistry = new TypeRegistry(configBuilder.getGlobalConfig());
    }

    @Override
    @NotNull
    public List<TableInfo> queryTables() {
        boolean isInclude = this.strategyConfig.getInclude().size() > 0;
        boolean isExclude = this.strategyConfig.getExclude().size() > 0;
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        List<DatabaseMetaDataWrapper.Table> tables = this.getTables();
        ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        tables.forEach(table -> {
            String tableName = table.getName();
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                tableInfo.setComment(table.getRemarks());
                if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                    includeTableList.add(tableInfo);
                } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                    excludeTableList.add(tableInfo);
                }
                tableList.add(tableInfo);
            }
        });
        this.filter(tableList, includeTableList, excludeTableList);
        tableList.forEach(this::convertTableFields);
        return tableList;
    }

    protected List<DatabaseMetaDataWrapper.Table> getTables() {
        String[] stringArray;
        boolean skipView = this.strategyConfig.isSkipView();
        if (skipView) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "TABLE";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "TABLE";
            stringArray = stringArray3;
            stringArray3[1] = "VIEW";
        }
        return this.databaseMetaDataWrapper.getTables(null, stringArray);
    }

    protected void convertTableFields(@NotNull TableInfo tableInfo) {
        String tableName = tableInfo.getName();
        Map<String, DatabaseMetaDataWrapper.Column> columnsInfoMap = this.getColumnsInfo(tableName);
        Entity entity = this.strategyConfig.entity();
        columnsInfoMap.forEach((k, columnInfo) -> {
            TableField.MetaInfo metaInfo = new TableField.MetaInfo((DatabaseMetaDataWrapper.Column)columnInfo);
            String columnName = columnInfo.getName();
            TableField field = new TableField(this.configBuilder, columnName);
            if (columnInfo.isPrimaryKey()) {
                field.primaryKey(columnInfo.isAutoIncrement());
                tableInfo.setHavePrimaryKey(true);
                if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                    this.LOGGER.warn("\u5f53\u524d\u8868[{}]\u7684\u4e3b\u952e\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4f1a\u5bfc\u81f4\u5168\u5c40\u4e3b\u952e\u7684ID\u7c7b\u578b\u8bbe\u7f6e\u5931\u6548!", (Object)tableName);
                }
            }
            field.setColumnName(columnName).setComment(columnInfo.getRemarks());
            String propertyName = entity.getNameConvert().propertyNameConvert(field);
            IColumnType columnType = this.typeRegistry.getColumnType(metaInfo);
            ITypeConvertHandler typeConvertHandler = this.dataSourceConfig.getTypeConvertHandler();
            if (typeConvertHandler != null) {
                columnType = typeConvertHandler.convert(this.globalConfig, this.typeRegistry, metaInfo);
            }
            field.setPropertyName(propertyName, columnType);
            field.setMetaInfo(metaInfo);
            tableInfo.addField(field);
        });
        tableInfo.processTable();
    }

    protected Map<String, DatabaseMetaDataWrapper.Column> getColumnsInfo(String tableName) {
        return this.databaseMetaDataWrapper.getColumnsInfo(tableName, true);
    }
}

