/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.office;

import com.kg.component.office.WordWriteStringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;

public class WordWriteImageUtils {
    public static XWPFParagraph imageInTableAutoSize(XWPFDocument doc, String keyStr, File imgFile, boolean isAppend) {
        try {
            BufferedImage imgRead = ImageIO.read(imgFile);
            int width = imgRead.getWidth();
            int height = imgRead.getHeight();
            if (width > 600) {
                height = 600 * height / width;
                width = 600;
            }
            if (height > 930) {
                width = 930 * width / height;
                height = 930;
            }
            return WordWriteImageUtils.writeInTable(doc, keyStr, imgFile, WordWriteImageUtils.getPictureType(imgFile.getName()), width, height, isAppend);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XWPFParagraph imageInTable(XWPFDocument doc, String keyStr, File imgFile, int width, int height, boolean isAppend) {
        return WordWriteImageUtils.writeInTable(doc, keyStr, imgFile, WordWriteImageUtils.getPictureType(imgFile.getName()), width, height, isAppend);
    }

    private static XWPFParagraph writeInTable(XWPFDocument doc, String keyStr, File imgFile, int imgType, int width, int height, boolean isAppend) {
        try {
            String key = "${" + keyStr + "}";
            List tables = doc.getTables();
            for (XWPFTable table : tables) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        XWPFParagraph newParagraph = WordWriteStringUtils.write(cell.getParagraphs(), key, "", null, false);
                        if (newParagraph == null) continue;
                        XWPFRun run = newParagraph.createRun();
                        run.addPicture((InputStream)new FileInputStream(imgFile), imgType, null, Units.toEMU((double)Units.pixelToPoints((double)width)), Units.toEMU((double)Units.pixelToPoints((double)height)));
                        newParagraph.setAlignment(ParagraphAlignment.CENTER);
                        if (isAppend) {
                            cell.addParagraph().createRun().setText("${" + keyStr + "}");
                        }
                        return newParagraph;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static XWPFParagraph imageWriteAutoSize(XWPFDocument doc, String keyStr, File imgFile, boolean isAppend) {
        try {
            BufferedImage imgRead = ImageIO.read(imgFile);
            int width = imgRead.getWidth();
            int height = imgRead.getHeight();
            if (width > 600) {
                height = 600 * height / width;
                width = 600;
            }
            if (height > 930) {
                width = 930 * width / height;
                height = 930;
            }
            return WordWriteImageUtils.write(doc, keyStr, imgFile, WordWriteImageUtils.getPictureType(imgFile.getName()), width, height, isAppend);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XWPFParagraph imageWrite(XWPFDocument doc, String keyStr, File imgFile, int width, int height, boolean isAppend) {
        return WordWriteImageUtils.write(doc, keyStr, imgFile, WordWriteImageUtils.getPictureType(imgFile.getName()), width, height, isAppend);
    }

    private static XWPFParagraph write(XWPFDocument doc, String keyStr, File imgFile, int imgType, int width, int height, boolean isAppend) {
        try {
            XWPFParagraph currentParagraph = WordWriteStringUtils.writeStrNewline(doc, keyStr, "", null, false);
            XmlCursor cursor = currentParagraph.getCTP().newCursor();
            XWPFParagraph newParagraph = doc.insertNewParagraph(cursor);
            XWPFRun run = newParagraph.createRun();
            run.addPicture((InputStream)new FileInputStream(imgFile), imgType, null, Units.toEMU((double)Units.pixelToPoints((double)width)), Units.toEMU((double)Units.pixelToPoints((double)height)));
            newParagraph.setAlignment(ParagraphAlignment.CENTER);
            if (isAppend) {
                currentParagraph.createRun().setText("${" + keyStr + "}");
            }
            return newParagraph;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getPictureType(String filename) {
        String extension;
        switch (extension = filename.toLowerCase().substring(filename.lastIndexOf(".") + 1)) {
            case "jpg": {
                return 5;
            }
            case "jpeg": {
                return 5;
            }
            case "png": {
                return 6;
            }
            case "gif": {
                return 8;
            }
            case "tiff": {
                return 9;
            }
            case "bpm": {
                return 11;
            }
        }
        return 5;
    }
}

