/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.office;

import com.kg.component.office.WordWriteStringUtils;
import com.kg.component.office.dto.WordStrFormatDTO;
import com.kg.component.office.dto.WordTableFormatDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class WordWriteTableUtils {
    public static XWPFTable tableWriteByKey(XWPFDocument doc, String keyStr, int rowLength, int columnLength, boolean isAppend) {
        XWPFParagraph currentParagraph = WordWriteStringUtils.writeStrNewline(doc, keyStr, "", null, false);
        XmlCursor cursor = currentParagraph.getCTP().newCursor();
        XWPFTable table = doc.insertNewTbl(cursor);
        for (int i = 0; i < rowLength; ++i) {
            XWPFTableRow row = i < table.getNumberOfRows() ? table.getRow(i) : table.createRow();
            for (int j = 0; j < columnLength; ++j) {
                if (j < row.getTableCells().size()) continue;
                row.createCell();
            }
        }
        if (isAppend) {
            currentParagraph.createRun().setText("${" + keyStr + "}");
        }
        return table;
    }

    public static void tableWriteRowOne(XWPFTable table, int startRow, List<String> rowData, boolean cover) {
        WordWriteTableUtils.tableWriteRowOne(table, startRow, rowData, cover, null);
    }

    public static void tableWriteRowOne(XWPFTable table, int startRow, List<String> rowData, boolean cover, WordStrFormatDTO format) {
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        rowList.add(rowData);
        WordWriteTableUtils.tableWriteRowList(table, startRow, rowList, cover, format);
    }

    public static void tableWriteRowList(XWPFTable table, int startRow, List<List<String>> rowList, boolean cover) {
        WordWriteTableUtils.tableWriteRowList(table, startRow, rowList, cover, null);
    }

    public static void tableWriteRowList(XWPFTable table, int startRow, List<List<String>> rowList, boolean cover, WordStrFormatDTO format) {
        int rowIndex = startRow < 0 ? 0 : startRow;
        for (List<String> cellData : rowList) {
            XWPFTableRow row = rowIndex < table.getNumberOfRows() ? table.getRow(rowIndex) : table.createRow();
            for (int i = 0; i < cellData.size(); ++i) {
                XWPFTableCell cell;
                if (cellData.get(i) == null) continue;
                XWPFTableCell xWPFTableCell = cell = i < row.getTableCells().size() ? row.getCell(i) : row.createCell();
                if (cover) {
                    for (int j = cell.getParagraphs().size() - 1; j >= 0; --j) {
                        cell.removeParagraph(j);
                    }
                }
                XWPFRun run = cell.getParagraphs().size() > 0 ? ((XWPFParagraph)cell.getParagraphs().get(0)).createRun() : cell.addParagraph().createRun();
                run.setText(cellData.get(i));
                if (format == null) continue;
                WordWriteStringUtils.runTextFormat(run, format);
            }
            ++rowIndex;
        }
    }

    public static void tableMerge(XWPFTable table, int startRow, int endRow, int startCol, int endCol) {
        for (int i = startRow; i <= endRow; ++i) {
            XWPFTableRow row = table.getRow(i);
            for (int j = startCol; j <= endCol; ++j) {
                if (endRow > startRow) {
                    if (i == startRow) {
                        row.getCell(j).getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.RESTART);
                    } else {
                        row.getCell(j).getCTTc().addNewTcPr().addNewVMerge().setVal(STMerge.CONTINUE);
                    }
                }
                if (endCol <= startCol) continue;
                if (j == startCol) {
                    row.getCell(j).getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.RESTART);
                    continue;
                }
                row.getCell(j).getCTTc().addNewTcPr().addNewHMerge().setVal(STMerge.CONTINUE);
            }
        }
    }

    public static void tableFormat(XWPFTable table, WordTableFormatDTO format) {
        table.setWidthType(format.getWidthType());
        table.setWidth(format.getWidth());
        table.setTableAlignment(TableRowAlign.RIGHT);
        table.getRows().stream().forEach(r -> {
            r.setHeight(format.getRowHeight());
            r.getTableCells().stream().forEach(c -> {
                c.getParagraphs().forEach(p -> {
                    p.setAlignment(format.getCellAlign());
                    p.setSpacingBefore(format.getCellSpaceBefore());
                    p.setSpacingAfter(format.getCellSpaceAfter());
                });
                c.setVerticalAlignment(format.getCellValign());
                c.setColor(format.getBgColor());
            });
        });
    }

    public static void tableCellFormat(XWPFTable table, int startRow, int endRow, int startCol, int endCol, WordTableFormatDTO format) {
        for (int i = startRow; i <= endRow; ++i) {
            XWPFTableRow row = table.getRow(i);
            row.setHeight(format.getRowHeight());
            for (int j = startCol; j <= endCol; ++j) {
                XWPFTableCell c = row.getCell(j);
                c.getParagraphs().forEach(p -> {
                    p.setAlignment(format.getCellAlign());
                    p.setSpacingBefore(format.getCellSpaceBefore());
                    p.setSpacingAfter(format.getCellSpaceAfter());
                });
                c.setVerticalAlignment(format.getCellValign());
                c.setColor(format.getBgColor());
            }
        }
        if (format.getBorderType() != null) {
            table.setLeftBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
            table.setRightBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
            table.setTopBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
            table.setBottomBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
            table.setInsideHBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
            table.setInsideVBorder(format.getBorderType(), format.getBorderSize(), format.getBorderSpace(), format.getBorderColor());
        }
    }
}

