/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.pdf;

import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.WorksheetCollection;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import java.io.File;

public class ExcelToPdfUtils {
    public static FileDTO toPdf(String filePath) throws Exception {
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(filePath);
        return ExcelToPdfUtils.toPdf(fileDTO, -1);
    }

    public static FileDTO toPdf(String filePath, int sheetIndex) throws Exception {
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(filePath);
        return ExcelToPdfUtils.toPdf(fileDTO, sheetIndex);
    }

    public static FileDTO toPdf(FileDTO fileDTO) throws Exception {
        return ExcelToPdfUtils.toPdf(fileDTO, -1);
    }

    public static FileDTO toPdf(FileDTO fileDTO, int sheetIndex) throws Exception {
        WorksheetCollection sheets;
        String savePath = FilePathConfig.switchSavePath(fileDTO.getFileUrl());
        Workbook workbook = new Workbook(savePath);
        if (sheetIndex >= 0 && sheetIndex < (sheets = workbook.getWorksheets()).getCount()) {
            for (int i = 0; i < sheets.getCount(); ++i) {
                if (i == sheetIndex) continue;
                sheets.get(i).setVisible(false);
            }
        }
        String pdfSavePath = savePath.substring(0, savePath.lastIndexOf(".")) + ".pdf";
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setOnePagePerSheet(true);
        workbook.save(pdfSavePath, (SaveOptions)pdfSaveOptions);
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf(File.separator) + 1));
        return fileDTO;
    }
}

