/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.pdf;

import cn.hutool.core.io.FileUtil;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class ImgToPdfUtils {
    public static FileDTO toPdf(String imgPath) throws IOException {
        return ImgToPdfUtils.toPdf(imgPath, null, null);
    }

    public static FileDTO toPdf(String imgPath, Integer width, Integer height) throws IOException {
        String s = FilePathConfig.switchSavePath(imgPath);
        return ImgToPdfUtils.toPdf(s, s.substring(0, s.lastIndexOf(".")) + ".pdf", width, height);
    }

    public static FileDTO toPdf(String imgPath, String pdfSavePath) throws IOException {
        return ImgToPdfUtils.toPdf(imgPath, pdfSavePath, null, null);
    }

    public static FileDTO toPdf(String imgPath, String pdfSavePath, Integer width, Integer height) throws IOException {
        PDDocument document = new PDDocument();
        ImgToPdfUtils.write(document, imgPath, width.intValue(), height.intValue());
        FileUtil.mkParentDirs((String)pdfSavePath);
        document.save(pdfSavePath);
        document.close();
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf(File.separator) + 1));
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileOldName(imgPath.substring(imgPath.lastIndexOf(File.separator) + 1));
        return fileDTO;
    }

    public static FileDTO listToPdf(String[] imgPaths, String pdfSavePath) throws IOException {
        return ImgToPdfUtils.listToPdf(imgPaths, pdfSavePath, null, null);
    }

    public static FileDTO listToPdf(String[] imgPaths, String pdfSavePath, Integer width, Integer height) throws IOException {
        return ImgToPdfUtils.listToPdf(Arrays.asList(imgPaths), pdfSavePath, width, height);
    }

    public static FileDTO listToPdf(List<String> imgPathList, String pdfSavePath) throws IOException {
        return ImgToPdfUtils.listToPdf(imgPathList, pdfSavePath, null, null);
    }

    public static FileDTO listToPdf(List<String> imgPathList, String pdfSavePath, Integer width, Integer height) throws IOException {
        PDDocument document = new PDDocument();
        for (String imgPath : imgPathList) {
            ImgToPdfUtils.write(document, imgPath, width.intValue(), height.intValue());
        }
        FileUtil.mkParentDirs((String)pdfSavePath);
        document.save(pdfSavePath);
        document.close();
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        String fileName = pdfSavePath.substring(pdfSavePath.lastIndexOf(File.separator) + 1);
        fileDTO.setFileName(fileName);
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileOldName(fileName);
        return fileDTO;
    }

    private static void write(PDDocument document, String imgPath, float maxWidth, float maxHeight) throws IOException {
        BufferedImage image = ImageIO.read(new File(imgPath));
        float width = image.getWidth();
        float height = image.getHeight();
        if (width > maxWidth || height > maxHeight) {
            float widthRatio = maxWidth / width;
            float heightRatio = maxHeight / height;
            float ratio = Math.min(widthRatio, heightRatio);
            width *= ratio;
            height *= ratio;
        }
        PDPage page = new PDPage(new PDRectangle(maxWidth, maxHeight));
        document.addPage(page);
        PDImageXObject pdImage = PDImageXObject.createFromFile((String)imgPath, (PDDocument)document);
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.drawImage(pdImage, 0.0f, maxHeight - height, width, height);
        contentStream.close();
    }
}

