/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.redis;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisUtils {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean setNoTimeLimit(String key, Object value) {
        boolean result = false;
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            result = true;
            this.updateSaveKeysList(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, 10L, TimeUnit.MINUTES);
            result = true;
            this.updateSaveKeysList(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long timeout) {
        boolean result = false;
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), TimeUnit.SECONDS);
            result = true;
            this.updateSaveKeysList(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Date endtime) {
        boolean result = false;
        try {
            Long timeout = DateUtil.between((Date)DateUtil.date(), (Date)endtime, (DateUnit)DateUnit.SECOND);
            this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), TimeUnit.SECONDS);
            result = true;
            this.updateSaveKeysList(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean setExpire(String key, Long timeout) {
        boolean result = false;
        try {
            this.redisTemplate.expire((Object)key, timeout.longValue(), TimeUnit.SECONDS);
            result = true;
            this.updateSaveKeysList(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean delete(String key) {
        boolean result = false;
        try {
            this.redisTemplate.delete((Object)key);
            result = true;
            this.updateSaveKeysList(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getSaveKeysList() {
        Object keys;
        if (this.redisTemplate.hasKey((Object)"REDIS_ALL_SAVE_KEYS_LIST").booleanValue() && (keys = this.redisTemplate.opsForValue().get((Object)"REDIS_ALL_SAVE_KEYS_LIST")) != null && !"".equals(keys.toString())) {
            return Arrays.asList(keys.toString().split(","));
        }
        return new ArrayList<String>();
    }

    public void updateSaveKeysList(String key) {
        ThreadUtil.execute(() -> {
            String lockKey = "updateSaveKeysList_lock";
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"locked");
            if (locked != null && locked.booleanValue()) {
                try {
                    ArrayList<String> allKeys = new ArrayList<String>(this.getSaveKeysList());
                    if (StringUtils.hasText((String)key) && !allKeys.contains(key)) {
                        allKeys.add(key);
                    }
                    List updateList = allKeys.stream().filter(k -> this.redisTemplate.hasKey(k)).collect(Collectors.toList());
                    this.redisTemplate.opsForValue().set((Object)"REDIS_ALL_SAVE_KEYS_LIST", (Object)updateList.stream().collect(Collectors.joining(",")));
                }
                finally {
                    this.redisTemplate.delete((Object)lockKey);
                }
            }
            try {
                Thread.sleep(1000L);
                this.updateSaveKeysList(key);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Thread.currentThread().interrupt();
        });
    }
}

