/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.sms.aliyun;

import cn.hutool.json.JSONUtil;
import cn.hutool.log.StaticLog;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.kg.component.sms.aliyun.AliyunConfig;
import com.kg.component.sms.aliyun.AliyunSmsResult;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AliyunSmsSender {
    @Resource
    private AliyunConfig aliyunConfig;

    public AliyunSmsResult send(String templateId, String phones, String paramJson) {
        return this.sendCoverConfig(null, templateId, phones, paramJson);
    }

    public AliyunSmsResult sendCoverSign(String sign, String templateId, String phones, String paramJson) {
        AliyunConfig cfg = this.aliyunConfig;
        cfg.setSign(sign);
        return this.sendCoverConfig(cfg, templateId, phones, paramJson);
    }

    public AliyunSmsResult sendCoverConfig(AliyunConfig cfg, String templateId, String phones, String paramJson) {
        AliyunSmsResult result = new AliyunSmsResult();
        try {
            System.out.println("=====");
            System.out.println(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"));
            System.out.println("=====");
            Client client = this.createClient(cfg != null ? cfg : this.aliyunConfig);
            String sign = cfg != null && StringUtils.hasText((String)cfg.getSign()) ? cfg.getSign() : this.aliyunConfig.getSign();
            result.setSign(sign);
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName(sign).setTemplateCode(templateId).setPhoneNumbers(phones).setTemplateParam(paramJson);
            SendSmsResponseBody body = client.sendSmsWithOptions(sendSmsRequest, new RuntimeOptions()).getBody();
            if (body != null) {
                if (StringUtils.hasText((String)body.getCode()) && "OK".equals(body.getCode())) {
                    result.setSuccess(true);
                    result.setResultJson(JSONUtil.toJsonStr((Object)body));
                    return result;
                }
                StaticLog.warn((String)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01\u5931\u8d25\u4fe1\u606fbody\uff1a" + body), (Object[])new Object[0]);
                result.setSuccess(false);
                result.setErrorMessage(body.getMessage());
                result.setResultJson(JSONUtil.toJsonStr((Object)body));
                return result;
            }
        }
        catch (TeaException error) {
            System.out.println(error.getMessage() + "\nRecommend:" + error.getData().get("Recommend"));
            result.setSuccess(false);
            result.setErrorMessage(error.getMessage());
            return result;
        }
        catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), (Throwable)_error);
            System.out.println(error.getMessage() + "\nRecommend:" + error.getData().get("Recommend"));
            result.setSuccess(false);
            result.setErrorMessage(error.getMessage());
            return result;
        }
        result.setErrorMessage("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01\u672a\u77e5\u5f02\u5e38");
        return result;
    }

    private Client createClient(AliyunConfig cfg) throws Exception {
        Config config = new Config();
        if (cfg != null) {
            config.setAccessKeyId(StringUtils.hasText((String)cfg.getAccessKeyId()) ? cfg.getAccessKeyId() : this.aliyunConfig.getAccessKeyId());
            config.setAccessKeySecret(StringUtils.hasText((String)cfg.getAccessKeySecret()) ? cfg.getAccessKeySecret() : this.aliyunConfig.getAccessKeySecret());
            config.setEndpoint(StringUtils.hasText((String)cfg.getEndpoint()) ? cfg.getEndpoint() : this.aliyunConfig.getEndpoint());
        } else {
            config.setAccessKeyId(this.aliyunConfig.getAccessKeyId());
            config.setAccessKeySecret(this.aliyunConfig.getAccessKeySecret());
            config.setEndpoint(this.aliyunConfig.getEndpoint());
        }
        return new Client(config);
    }
}

