/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.swagger;

import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@ConditionalOnProperty(name={"com.kg.swagger.enable"}, havingValue="true")
public class SwaggerConfig {
    @Value(value="${com.kg.swagger.title}")
    private String title;
    @Value(value="${com.kg.swagger.description}")
    private String description;
    @Value(value="${com.kg.swagger.terms-of-service-url}")
    private String termsOfServiceUrl;
    @Value(value="${com.kg.swagger.version}")
    private String version;
    @Value(value="${com.kg.swagger.concat.name}")
    private String name;
    @Value(value="${com.kg.swagger.concat.www}")
    private String www;
    @Value(value="${com.kg.swagger.concat.email}")
    private String email;

    @Bean
    public ApiInfo apiInfo() {
        Contact contact = new Contact(this.name, this.www, this.email);
        return new ApiInfoBuilder().title(this.title).description(this.description).termsOfServiceUrl(this.termsOfServiceUrl).contact(contact).version(this.version).build();
    }

    @Bean
    public Docket allApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).groupName("allApi").select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
    }
}

