/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.baidubce.http.ApiExplorerClient;
import com.baidubce.http.HttpMethodName;
import com.baidubce.model.ApiExplorerRequest;
import com.baidubce.model.ApiExplorerResponse;
import com.kg.component.utils.BaiduAccessToken;
import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaiduOCR {
    @Autowired
    private BaiduAccessToken baiduAccessToken;

    public JSONArray textRecognition(String billImage) {
        try {
            String path = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic";
            ApiExplorerRequest request = new ApiExplorerRequest(HttpMethodName.POST, path);
            request.addHeaderParameter("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            request.addQueryParameter("access_token", this.baiduAccessToken.GetAccessToken());
            String jsonBody = "image=" + URLEncoder.encode(billImage, "UTF-8") + "&paragraph=true";
            request.setJsonBody(jsonBody);
            ApiExplorerClient client = new ApiExplorerClient();
            ApiExplorerResponse response = client.sendRequest(request);
            System.out.println(response.getResult());
            JSONObject jsonObj = new JSONObject((Object)response.getResult());
            JSONArray jsonArray = jsonObj.getJSONArray((Object)"words_result");
            return jsonArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

