/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import java.util.regex.Pattern;

public class PasswordRegexUtils {
    public static boolean judgeLength(int min, int max, String password) {
        if (min <= max) {
            String regex = ".{" + min + "," + max + "}";
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(password).matches();
        }
        return false;
    }

    public static boolean judgeRegex(Integer lowerStatus, Integer upperStatus, Integer numStatus, Integer specialStatus, String password) {
        String regex;
        Pattern pattern;
        boolean flag;
        if (lowerStatus != null && !(flag = (pattern = Pattern.compile(regex = PasswordRegexUtils.regexLowerCase(lowerStatus))).matcher(password).matches())) {
            return flag;
        }
        if (upperStatus != null && !(flag = (pattern = Pattern.compile(regex = PasswordRegexUtils.regexUpperCase(upperStatus))).matcher(password).matches())) {
            return flag;
        }
        if (numStatus != null && !(flag = (pattern = Pattern.compile(regex = PasswordRegexUtils.regexNumber(numStatus))).matcher(password).matches())) {
            return flag;
        }
        if (specialStatus != null && !(flag = (pattern = Pattern.compile(regex = PasswordRegexUtils.regexSpecial(specialStatus))).matcher(password).matches())) {
            return flag;
        }
        return true;
    }

    private static String regexLowerCase(int status) {
        try {
            if (status == 1) {
                return "(?=.*[a-z]).*";
            }
            if (status == 2) {
                return ".*";
            }
            return "(?!.*[a-z]).*";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "(?!.*[a-z]).*";
        }
    }

    private static String regexUpperCase(int status) {
        try {
            if (status == 1) {
                return "(?=.*[A-Z]).*";
            }
            if (status == 2) {
                return ".*";
            }
            return "(?!.*[A-Z]).*";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "(?!.*[A-Z]).*";
        }
    }

    private static String regexNumber(int status) {
        try {
            if (status == 1) {
                return "(?=.*[0-9]).*";
            }
            if (status == 2) {
                return ".*";
            }
            return "(?!.*[0-9]).*";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "(?!.*[0-9]).*";
        }
    }

    private static String regexSpecial(int status) {
        try {
            if (status == 1) {
                return "(?=.*[*?!&\uffe5$%^#,.@;:\\-=+_\\|\u300b\u300a\u3002\uff0c\u3001\uff1f\uff01~]).*";
            }
            if (status == 2) {
                return ".*";
            }
            return "[a-zA-Z0-9]*";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "[a-zA-Z0-9]*";
        }
    }
}

