/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    private long timestamp;

    public static TimeUtils setTime(long timeStamp) {
        return new TimeUtils(timeStamp);
    }

    public static TimeUtils setTime(Date date) {
        return new TimeUtils(date.getTime());
    }

    public static TimeUtils setTime(LocalDateTime localDateTime) {
        return new TimeUtils(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static TimeUtils setTime(String dateStr) throws ParseException {
        return TimeUtils.setTime(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static TimeUtils setTime(String dateStr, String formatStr) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(formatStr);
        return new TimeUtils(formatter.parse(dateStr).getTime());
    }

    public static TimeUtils now() {
        return new TimeUtils(Calendar.getInstance().getTimeInMillis());
    }

    public TimeUtils addYear(int amount) {
        return this.add(1, amount);
    }

    public TimeUtils addMonth(int amount) {
        return this.add(2, amount);
    }

    public TimeUtils addDay(int amount) {
        return this.add(5, amount);
    }

    public TimeUtils addHour(int amount) {
        return this.add(11, amount);
    }

    public TimeUtils addMinute(int amount) {
        return this.add(12, amount);
    }

    public TimeUtils addSecond(int amount) {
        return this.add(13, amount);
    }

    public TimeUtils add(int type, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        calendar.add(type, amount);
        return new TimeUtils(calendar.getTimeInMillis());
    }

    public long toTimestamp() {
        return this.timestamp;
    }

    public Date toDate() {
        return new Date(this.timestamp);
    }

    public LocalDateTime toLocalDateTime() {
        Instant instant = Instant.ofEpochMilli(this.timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public Calendar toCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timestamp);
        return calendar;
    }

    public Timestamp toSqlTimestamp() {
        return new Timestamp(this.timestamp);
    }

    public String toFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(this.timestamp));
    }

    public String toString(String format) {
        return this.toFormat(format);
    }

    public String toString() {
        return this.toFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static void main(String[] args) {
        System.out.println(TimeUtils.now());
        System.out.println(TimeUtils.setTime(new Date()));
        System.out.println(TimeUtils.now().addDay(1).toLocalDateTime());
        System.out.println(TimeUtils.now().addDay(1).toTimestamp());
        System.out.println(TimeUtils.now().addDay(-5).toFormat("yyyy-MM-dd"));
        System.out.println(TimeUtils.now().addMinute(10).toFormat("yyyy-MM-dd HH:mm:ss"));
        System.out.println("---");
        System.out.println(TimeUtils.now());
    }

    public TimeUtils() {
    }

    public TimeUtils(long timestamp) {
        this.timestamp = timestamp;
    }
}

