/*
 * Copyright (c) 2011-2021, baomidou (jobob@qq.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.kg.component.generator.config.builder;

import com.kg.component.generator.config.IConfigBuilder;
import com.kg.component.generator.config.StrategyConfig;
import org.jetbrains.annotations.NotNull;

/**
 * 配置构建
 *
 * @author nieqiurong 2020/10/11.
 * @since 3.5.0
 */
public class BaseBuilder implements IConfigBuilder<StrategyConfig> {

    private final StrategyConfig strategyConfig;

    public BaseBuilder(@NotNull StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    @NotNull
    public Entity.Builder entityBuilder() {
        return strategyConfig.entityBuilder();
    }

    @NotNull
    public DTO.Builder dtoBuilder() {
        return strategyConfig.dtoBuilder();
    }

    @NotNull
    public Excels.Builder excelsBuilder() {
        return strategyConfig.excelsBuilder();
    }

    @NotNull
    public Controller.Builder controllerBuilder() {
        return strategyConfig.controllerBuilder();
    }

    @NotNull
    public IndexVue.Builder indexVueBuilder() {
        return strategyConfig.indexVueBuilder();
    }

    @NotNull
    public PermissionSQL.Builder permissionSQLBuilder() {
        return strategyConfig.permissionSqlBuilder();
    }

    @NotNull
    public Mapper.Builder mapperBuilder() {
        return strategyConfig.mapperBuilder();
    }

    @NotNull
    public Service.Builder serviceBuilder() {
        return strategyConfig.serviceBuilder();
    }

    @NotNull
    @Override
    public StrategyConfig build() {
        this.strategyConfig.validate();
        return this.strategyConfig;
    }
}
