/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.file.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileMD5Utils {
    public static String getFileMD5(String filePath) throws FileNotFoundException {
        return FileMD5Utils.getFileMD5(new FileInputStream(filePath));
    }

    public static String getFileMD5(File file) throws FileNotFoundException {
        return FileMD5Utils.getFileMD5(new FileInputStream(file));
    }

    public static String getFileMD5(InputStream is) throws FileNotFoundException {
        return FileMD5Utils.getFileMD5((FileInputStream)is);
    }

    public static String getFileMD5(FileInputStream fis) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int n = 0;
            while ((n = fis.read(buffer)) != -1) {
                md.update(buffer, 0, n);
            }
            byte[] md5Bytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte md5Byte : md5Bytes) {
                sb.append(Integer.toString((md5Byte & 0xFF) + 256, 16).substring(1));
            }
            fis.close();
            return sb.toString().toUpperCase();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

