/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.file.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class FileTypeUtils {
    public static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();

    public static void loadFileType() {
        FILE_TYPE_MAP.clear();
        List antMatchers = FileUtil.readLines((String)"fileTypeMap.properties", (Charset)CharsetUtil.defaultCharset());
        antMatchers.stream().filter(str -> StringUtils.hasText((String)str) && !str.startsWith("#")).forEach(str -> {
            String[] split = str.split("\\|");
            if (split.length == 2) {
                FILE_TYPE_MAP.put(split[0], split[1]);
            }
        });
    }

    public static String getFileType(String filePath) throws IOException {
        return FileTypeUtils.getFileType(new FileInputStream(filePath));
    }

    public static String getFileType(File file) throws IOException {
        return FileTypeUtils.getFileType(new FileInputStream(file));
    }

    public static String getFileType(FileInputStream fis) throws IOException {
        byte[] bytes = new byte[10];
        fis.read(bytes, 0, bytes.length);
        return FileTypeUtils.assertFileType(bytes);
    }

    public static String getFileType(byte[] fileBytes) throws IOException {
        byte[] bytes = new byte[10];
        for (int i = 0; i < bytes.length && fileBytes.length != 0 && fileBytes.length > i; ++i) {
            bytes[i] = fileBytes[i];
        }
        return FileTypeUtils.assertFileType(bytes);
    }

    private static String assertFileType(byte[] bytes) {
        String fileCode = FileTypeUtils.getFileHeader(bytes);
        String res = null;
        for (String key : FILE_TYPE_MAP.keySet()) {
            if (!key.toLowerCase().startsWith(fileCode.toLowerCase()) && !fileCode.toLowerCase().startsWith(key.toLowerCase())) continue;
            res = FILE_TYPE_MAP.get(key);
            break;
        }
        return res == null ? null : res.toLowerCase();
    }

    public static String getFileHeader(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) throws Exception {
        File[] ls = FileUtil.ls((String)"E:\\");
        for (int i = 0; i < ls.length; ++i) {
            String type2 = ls[i].getName().substring(ls[i].getName().lastIndexOf(".") + 1);
            String type1 = null;
            try {
                FileInputStream fis = new FileInputStream(ls[i]);
                type1 = FileTypeUtils.getFileType(fis);
            }
            catch (IOException e) {
                continue;
            }
            if (type1 == null) {
                System.out.println("------------------------------------------------------------------------------------------------------" + type2 + "==============" + ls[i].getName());
                continue;
            }
            System.out.print(type2);
            System.out.print("               ");
            System.out.print(type1.contains(type2));
            System.out.print("               ");
            System.out.print(type1);
            System.out.print("               ");
            byte[] bytes = new byte[10];
            IoUtil.toStream((File)ls[i]).read(bytes, 0, bytes.length);
            System.out.print(FileTypeUtils.getFileHeader(bytes));
            System.out.println("");
        }
    }

    static {
        FileTypeUtils.loadFileType();
    }
}

