/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.file.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import com.kg.component.file.utils.FileTypeUtils;
import com.kg.component.utils.GuidUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class UploadFileUtils {
    public static List<FileDTO> upload(HttpServletRequest request, String dirName) throws IOException {
        ArrayList<FileDTO> resultList = new ArrayList<FileDTO>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        multipartRequest.setCharacterEncoding("UTF-8");
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry fileInput : fileMap.entrySet()) {
            String fileInputName = (String)fileInput.getKey();
            List fileList = multipartRequest.getFiles(fileInputName);
            for (MultipartFile multipartFile : fileList) {
                FileDTO file = new FileDTO();
                String oldFileName = FilePathConfig.removeSpec(multipartFile.getOriginalFilename());
                if (!StringUtils.hasText((String)oldFileName)) {
                    throw new IOException("\u4e0a\u4f20\u6587\u4ef6\u540d\u4e0d\u6b63\u786e\uff01\u8bf7\u68c0\u67e5");
                }
                file.setFileOldName(oldFileName);
                String extend = FileUtil.extName((String)oldFileName).toLowerCase();
                String extendStr = FileTypeUtils.getFileType(multipartFile.getBytes());
                if (StringUtils.hasText((String)extendStr) && extendStr.indexOf(extend) < 0) {
                    throw new IOException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0e\u6269\u5c55\u540d\u4e0d\u7b26\uff01\u8bf7\u68c0\u67e5");
                }
                if (FilePathConfig.UPLOAD_FILE_ALLOW_EXTEND.toLowerCase().indexOf(extend) < 0) {
                    throw new IOException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u88ab\u5141\u8bb8\uff01\u8bf7\u68c0\u67e5");
                }
                file.setFileExtend(extend);
                file.setFileName(GuidUtils.getUuid32() + "." + extend);
                file.setFileSize(multipartFile.getSize());
                String savePath = FilePathConfig.SAVE_PATH + "/" + dirName + "/" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "/" + file.getFileName();
                File saveFile = new File(savePath.replaceAll("//", "/"));
                FileUtil.mkParentDirs((File)saveFile);
                FileCopyUtils.copy((byte[])multipartFile.getBytes(), (File)saveFile);
                file.setFileUrl(FilePathConfig.switchUrl(savePath));
                resultList.add(file);
            }
        }
        return resultList;
    }

    public static List<FileDTO> uploadOriginal(HttpServletRequest request, String dirName) throws IOException {
        ArrayList<FileDTO> resultList = new ArrayList<FileDTO>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        multipartRequest.setCharacterEncoding("UTF-8");
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry fileInput : fileMap.entrySet()) {
            String fileInputName = (String)fileInput.getKey();
            List fileList = multipartRequest.getFiles(fileInputName);
            for (MultipartFile multipartFile : fileList) {
                FileDTO file = new FileDTO();
                String oldFileName = FilePathConfig.removeSpec(multipartFile.getOriginalFilename());
                if (!StringUtils.hasText((String)oldFileName)) {
                    throw new IOException("\u4e0a\u4f20\u6587\u4ef6\u540d\u4e0d\u6b63\u786e\uff01\u8bf7\u68c0\u67e5");
                }
                file.setFileOldName(oldFileName);
                String extend = FileUtil.extName((String)oldFileName).toLowerCase();
                String extendStr = FileTypeUtils.getFileType(multipartFile.getBytes());
                if (StringUtils.hasText((String)extendStr) && extendStr.indexOf(extend) < 0) {
                    throw new IOException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0e\u6269\u5c55\u540d\u4e0d\u7b26\uff01\u8bf7\u68c0\u67e5");
                }
                if (FilePathConfig.UPLOAD_FILE_ALLOW_EXTEND.toLowerCase().indexOf(extend) < 0) {
                    throw new IOException("\u60a8\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u88ab\u5141\u8bb8\uff01\u8bf7\u68c0\u67e5");
                }
                file.setFileExtend(extend);
                file.setFileName(oldFileName);
                file.setFileSize(multipartFile.getSize());
                String savePath = FilePathConfig.SAVE_PATH + "/" + dirName + "/" + file.getFileName();
                File saveFile = new File(savePath.replaceAll("//", "/"));
                FileUtil.mkParentDirs((File)saveFile);
                FileCopyUtils.copy((byte[])multipartFile.getBytes(), (File)saveFile);
                file.setFileUrl(FilePathConfig.switchUrl(savePath));
                resultList.add(file);
            }
        }
        return resultList;
    }

    public static FileDTO bufferToFile(byte[] buffer, String dirName, String extend) {
        try {
            FileDTO file = new FileDTO();
            file.setFileExtend(extend);
            file.setFileName(GuidUtils.getUuid32() + "." + extend);
            String savePath = FilePathConfig.SAVE_PATH + "/" + dirName + "/" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "/" + file.getFileName();
            File saveFile = new File(savePath.replaceAll("//", "/"));
            FileUtil.mkParentDirs((File)saveFile);
            FileCopyUtils.copy((byte[])buffer, (File)saveFile);
            file.setFileSize(saveFile.length());
            file.setFileUrl(FilePathConfig.switchUrl(savePath));
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

