/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config;

import com.kg.component.generator.config.IConfigBuilder;
import com.kg.component.generator.config.builder.CustomFile;
import com.kg.component.generator.config.po.TableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectionConfig.class);
    private BiConsumer<TableInfo, Map<String, Object>> beforeOutputFileBiConsumer;
    private Map<String, Object> customMap = new HashMap<String, Object>();
    @Deprecated
    private Map<String, String> customFile = new HashMap<String, String>();
    private List<CustomFile> customFiles = new ArrayList<CustomFile>();

    @NotNull
    public void beforeOutputFile(TableInfo tableInfo, Map<String, Object> objectMap) {
        if (!this.customMap.isEmpty()) {
            objectMap.putAll(this.customMap);
        }
        if (null != this.beforeOutputFileBiConsumer) {
            this.beforeOutputFileBiConsumer.accept(tableInfo, objectMap);
        }
    }

    @NotNull
    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    @Deprecated
    @NotNull
    public Map<String, String> getCustomFile() {
        return this.customFile;
    }

    @NotNull
    public List<CustomFile> getCustomFiles() {
        return this.customFiles;
    }

    public static class Builder
    implements IConfigBuilder<InjectionConfig> {
        private final InjectionConfig injectionConfig = new InjectionConfig();

        public Builder beforeOutputFile(@NotNull BiConsumer<TableInfo, Map<String, Object>> biConsumer) {
            this.injectionConfig.beforeOutputFileBiConsumer = biConsumer;
            return this;
        }

        public Builder customMap(@NotNull Map<String, Object> customMap) {
            this.injectionConfig.customMap = customMap;
            return this;
        }

        public Builder customFile(@NotNull Map<String, String> customFile) {
            return this.customFile(customFile.entrySet().stream().map(e -> new CustomFile.Builder().fileName((String)e.getKey()).templatePath((String)e.getValue()).build()).collect(Collectors.toList()));
        }

        public Builder customFile(@NotNull CustomFile customFile) {
            this.injectionConfig.customFiles.add(customFile);
            return this;
        }

        public Builder customFile(@NotNull List<CustomFile> customFiles) {
            this.injectionConfig.customFiles.addAll(customFiles);
            return this;
        }

        public Builder customFile(Consumer<CustomFile.Builder> consumer) {
            CustomFile.Builder builder = new CustomFile.Builder();
            consumer.accept(builder);
            this.injectionConfig.customFiles.add(builder.build());
            return this;
        }

        @Override
        public InjectionConfig build() {
            return this.injectionConfig;
        }
    }
}

