/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.config.builder;

import com.kg.component.generator.ITemplate;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.BaseBuilder;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.function.ConverterFileName;
import com.kg.component.generator.util.ClassUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    private String superServiceClass = "com.baomidou.mybatisplus.extension.service.IService";
    private String superServiceImplClass = "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl";
    private ConverterFileName converterServiceFileName = entityName -> entityName + "Service";
    private ConverterFileName converterServiceImplFileName = entityName -> entityName + "ServiceImpl";
    private boolean fileOverride;

    private Service() {
    }

    @NotNull
    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    @NotNull
    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    @NotNull
    public ConverterFileName getConverterServiceFileName() {
        return this.converterServiceFileName;
    }

    @NotNull
    public ConverterFileName getConverterServiceImplFileName() {
        return this.converterServiceImplFileName;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull ConfigBuilder config, @NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("superServiceClassPackage", this.superServiceClass);
        data.put("superServiceClass", ClassUtils.getSimpleName(this.superServiceClass));
        data.put("superServiceImplClassPackage", this.superServiceImplClass);
        data.put("superServiceImplClass", ClassUtils.getSimpleName(this.superServiceImplClass));
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final Service service = new Service();

        public Builder(@NotNull StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superServiceClass(@NotNull Class<?> clazz) {
            return this.superServiceClass(clazz.getName());
        }

        public Builder superServiceClass(@NotNull String superServiceClass) {
            this.service.superServiceClass = superServiceClass;
            return this;
        }

        public Builder superServiceImplClass(@NotNull Class<?> clazz) {
            return this.superServiceImplClass(clazz.getName());
        }

        public Builder superServiceImplClass(@NotNull String superServiceImplClass) {
            this.service.superServiceImplClass = superServiceImplClass;
            return this;
        }

        public Builder convertServiceFileName(@NotNull ConverterFileName converter) {
            this.service.converterServiceFileName = converter;
            return this;
        }

        public Builder convertServiceImplFileName(@NotNull ConverterFileName converter) {
            this.service.converterServiceImplFileName = converter;
            return this;
        }

        public Builder formatServiceFileName(@NotNull String format) {
            return this.convertServiceFileName(entityName -> String.format(format, entityName));
        }

        public Builder formatServiceImplFileName(@NotNull String format) {
            return this.convertServiceImplFileName(entityName -> String.format(format, entityName));
        }

        public Builder enableFileOverride() {
            this.service.fileOverride = true;
            return this;
        }

        @NotNull
        public Service get() {
            return this.service;
        }
    }
}

