/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.query;

import com.kg.component.generator.config.DataSourceConfig;
import com.kg.component.generator.config.GlobalConfig;
import com.kg.component.generator.config.StrategyConfig;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.config.querys.DbQueryDecorator;
import com.kg.component.generator.jdbc.DatabaseMetaDataWrapper;
import com.kg.component.generator.query.IDatabaseQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseQuery
implements IDatabaseQuery {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ConfigBuilder configBuilder;
    protected final DataSourceConfig dataSourceConfig;
    protected final StrategyConfig strategyConfig;
    protected final GlobalConfig globalConfig;
    protected final DbQueryDecorator dbQuery;
    protected final DatabaseMetaDataWrapper databaseMetaDataWrapper;

    public AbstractDatabaseQuery(@NotNull ConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
        this.dataSourceConfig = configBuilder.getDataSourceConfig();
        this.strategyConfig = configBuilder.getStrategyConfig();
        this.dbQuery = new DbQueryDecorator(this.dataSourceConfig, this.strategyConfig);
        this.globalConfig = configBuilder.getGlobalConfig();
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.dataSourceConfig);
    }

    @NotNull
    public ConfigBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    @NotNull
    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    protected void filter(List<TableInfo> tableList, List<TableInfo> includeTableList, List<TableInfo> excludeTableList) {
        boolean isExclude;
        boolean isInclude = this.strategyConfig.getInclude().size() > 0;
        boolean bl = isExclude = this.strategyConfig.getExclude().size() > 0;
        if (isExclude || isInclude) {
            Map<String, String> notExistTables = new HashSet<String>(isExclude ? this.strategyConfig.getExclude() : this.strategyConfig.getInclude()).stream().filter(s -> !ConfigBuilder.matcherRegTable(s)).collect(Collectors.toMap(String::toLowerCase, s -> s, (o, n) -> n));
            for (TableInfo tabInfo : tableList) {
                if (notExistTables.isEmpty()) break;
                notExistTables.remove(tabInfo.getName().toLowerCase());
            }
            if (notExistTables.size() > 0) {
                this.LOGGER.warn("\u8868[{}]\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object)String.join((CharSequence)",", notExistTables.values()));
            }
            if (isExclude) {
                tableList.removeAll(excludeTableList);
            } else {
                tableList.clear();
                tableList.addAll(includeTableList);
            }
        }
    }
}

