/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.generator.query;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.kg.component.generator.config.builder.ConfigBuilder;
import com.kg.component.generator.config.builder.Entity;
import com.kg.component.generator.config.po.TableField;
import com.kg.component.generator.config.po.TableInfo;
import com.kg.component.generator.config.rules.IColumnType;
import com.kg.component.generator.jdbc.DatabaseMetaDataWrapper;
import com.kg.component.generator.query.AbstractDatabaseQuery;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SQLQuery
extends AbstractDatabaseQuery {
    public SQLQuery(@NotNull ConfigBuilder configBuilder) {
        super(configBuilder);
    }

    @Override
    @NotNull
    public List<TableInfo> queryTables() {
        boolean isInclude = this.strategyConfig.getInclude().size() > 0;
        boolean isExclude = this.strategyConfig.getExclude().size() > 0;
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        try {
            this.dbQuery.execute(this.dbQuery.tablesSql(), result -> {
                String tableName = result.getStringResult(this.dbQuery.tableName());
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    TableInfo tableInfo = new TableInfo(this.configBuilder, tableName);
                    String tableComment = result.getTableComment();
                    if (!this.strategyConfig.isSkipView() || !"VIEW".equals(tableComment)) {
                        tableInfo.setComment(tableComment);
                        if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                            includeTableList.add(tableInfo);
                        } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                            excludeTableList.add(tableInfo);
                        }
                        tableList.add(tableInfo);
                    }
                }
            });
            this.filter(tableList, includeTableList, excludeTableList);
            tableList.forEach(this::convertTableFields);
            ArrayList<TableInfo> arrayList = tableList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.dbQuery.closeConnection();
        }
    }

    protected void convertTableFields(@NotNull TableInfo tableInfo) {
        DbType dbType = this.dataSourceConfig.getDbType();
        String tableName = tableInfo.getName();
        try {
            Map<String, DatabaseMetaDataWrapper.Column> columnsInfoMap = this.databaseMetaDataWrapper.getColumnsInfo(tableName, false);
            String tableFieldsSql = this.dbQuery.tableFieldsSql(tableName);
            HashSet h2PkColumns = new HashSet();
            if (DbType.H2 == dbType) {
                this.dbQuery.execute(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", tableName), result -> {
                    String primaryKey = result.getStringResult(this.dbQuery.fieldKey());
                    if (Boolean.parseBoolean(primaryKey)) {
                        h2PkColumns.add(result.getStringResult(this.dbQuery.fieldName()));
                    }
                });
            }
            Entity entity = this.strategyConfig.entity();
            this.dbQuery.execute(tableFieldsSql, result -> {
                boolean isId;
                String columnName = result.getStringResult(this.dbQuery.fieldName());
                TableField field = new TableField(this.configBuilder, columnName);
                DatabaseMetaDataWrapper.Column column = (DatabaseMetaDataWrapper.Column)columnsInfoMap.get(columnName.toLowerCase());
                TableField.MetaInfo metaInfo = new TableField.MetaInfo(column);
                boolean bl = isId = DbType.H2 == dbType ? h2PkColumns.contains(columnName) : result.isPrimaryKey();
                if (isId) {
                    field.primaryKey(this.dbQuery.isKeyIdentity(result.getResultSet()));
                    tableInfo.setHavePrimaryKey(true);
                    if (field.isKeyIdentityFlag() && entity.getIdType() != null) {
                        this.LOGGER.warn("\u5f53\u524d\u8868[{}]\u7684\u4e3b\u952e\u4e3a\u81ea\u589e\u4e3b\u952e\uff0c\u4f1a\u5bfc\u81f4\u5168\u5c40\u4e3b\u952e\u7684ID\u7c7b\u578b\u8bbe\u7f6e\u5931\u6548!", (Object)tableName);
                    }
                }
                field.setColumnName(columnName).setType(result.getStringResult(this.dbQuery.fieldType())).setComment(result.getFiledComment()).setCustomMap(this.dbQuery.getCustomFields(result.getResultSet()));
                String propertyName = entity.getNameConvert().propertyNameConvert(field);
                IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field);
                field.setPropertyName(propertyName, columnType);
                field.setMetaInfo(metaInfo);
                tableInfo.addField(field);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        tableInfo.processTable();
    }
}

