/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.jwt;

import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTUtil;
import com.kg.component.redis.RedisUtils;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtils {
    public static final String TOKEN_VALUE_NAME = "jwt_token_value";
    private static final byte[] JWT_TOKEN_KEY = "com.keepgrown.dashu.frame".getBytes();
    private static Integer JWT_EXPIRE_TIME;
    private static RedisUtils redisUtils;

    @Value(value="${com.kg.login.jwt-token-expiry}")
    public void setJwtTokenKey(Integer expiry) {
        JWT_EXPIRE_TIME = expiry;
    }

    @Autowired
    public JwtUtils(RedisUtils redisUtils) {
        JwtUtils.redisUtils = redisUtils;
    }

    public static String createToken(Object value) {
        String token = ((JWT)JWT.create().setKey(JWT_TOKEN_KEY).setExpiresAt(Date.from(LocalDateTime.now().plusMinutes(JWT_EXPIRE_TIME.intValue()).atZone(ZoneId.systemDefault()).toInstant()))).setPayload(TOKEN_VALUE_NAME, value).sign();
        redisUtils.set(token, (Object)true, (long)JWT_EXPIRE_TIME.intValue() * 60L);
        return token;
    }

    public static Object parseToken(String token) {
        if (JwtUtils.verifyToken(token)) {
            JWT jwt = JWTUtil.parseToken((String)token);
            return jwt.getPayload(TOKEN_VALUE_NAME);
        }
        throw new RuntimeException("Token\u5df2\u5931\u6548");
    }

    public static boolean verifyToken(String token) {
        return redisUtils.hasKey(token) && JWT.of((String)token).setKey(JWT_TOKEN_KEY).validate(0L);
    }

    public static void removeToken(String token) {
        if (redisUtils.hasKey(token)) {
            redisUtils.delete(token);
        }
    }
}

