/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.office;

import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import com.kg.component.file.utils.DownloadNetFileUtils;
import com.kg.component.office.dto.WordStrFormatDTO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WordWriteHtmlUtils {
    private static String API_BASE_URL;

    @Value(value="${com.kg.apiBaseUrl}")
    public void setApiBaseUrl(String apiBaseUrl) {
        API_BASE_URL = apiBaseUrl;
    }

    public static XWPFParagraph writeByKey(XWPFDocument doc, String key, String html, boolean isAppend) {
        return WordWriteHtmlUtils.writeByKey(doc, key, html, null, isAppend);
    }

    public static XWPFParagraph writeByKey(XWPFDocument doc, String key, String html, WordStrFormatDTO format, boolean isAppend) {
        key = "${" + key + "}";
        List paragraphs = doc.getParagraphs();
        XWPFParagraph result = WordWriteHtmlUtils.write(doc, paragraphs, key, html, format, isAppend);
        if (result == null) {
            List tables = doc.getTables();
            for (XWPFTable table : tables) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        result = WordWriteHtmlUtils.write(doc, cell.getParagraphs(), key, html, format, isAppend);
                        if (result == null) continue;
                        return result;
                    }
                }
            }
        }
        return result;
    }

    static XWPFParagraph write(XWPFDocument doc, List<XWPFParagraph> paragraphs, String key, String html, WordStrFormatDTO format, boolean isAppend) {
        for (XWPFParagraph paragraph : paragraphs) {
            Pattern pattern = Pattern.compile(Pattern.quote(key));
            StringBuilder sb = new StringBuilder();
            for (XWPFRun run : paragraph.getRuns()) {
                sb.append(run.getText(0));
            }
            String text = sb.toString();
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            for (int i = paragraph.getRuns().size() - 1; i > 0; --i) {
                paragraph.removeRun(i);
            }
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(0);
            run.setText(matcher.replaceAll(""), 0);
            if (format != null) {
                WordWriteHtmlUtils.runTextFormat(run, format);
            }
            XWPFParagraph newParagraph = WordWriteHtmlUtils.runHtmlWrite(doc, paragraph, html, format);
            if (isAppend) {
                newParagraph.createRun().setText(key);
            }
            return newParagraph;
        }
        return null;
    }

    private static XWPFParagraph runHtmlWrite(XWPFDocument doc, XWPFParagraph xwpfParagraph, String html, WordStrFormatDTO format) {
        Document jsoupDoc = Jsoup.parse((String)html);
        Elements elements = jsoupDoc.select("p");
        for (Element element : elements) {
            String text;
            Elements images = element.select("img");
            if (!images.isEmpty()) {
                for (Element image : images) {
                    String imgSrc = image.attr("src");
                    try {
                        File imgFile = WordWriteHtmlUtils.getImgFile(imgSrc);
                        BufferedImage imgRead = ImageIO.read(imgFile);
                        int width = imgRead.getWidth();
                        int height = imgRead.getHeight();
                        if (width > 600) {
                            height = 600 * height / width;
                            width = 600;
                        }
                        if (height > 930) {
                            width = 930 * width / height;
                            height = 930;
                        }
                        int imgType = WordWriteHtmlUtils.getPictureType(imgSrc);
                        xwpfParagraph.createRun().addPicture((InputStream)new FileInputStream(imgFile), imgType, null, Units.toEMU((double)Units.pixelToPoints((double)width)), Units.toEMU((double)Units.pixelToPoints((double)height)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (StringUtils.hasText((String)(text = element.text()))) {
                XWPFRun run = xwpfParagraph.createRun();
                run.setText(text);
                if (format != null) {
                    WordWriteHtmlUtils.runTextFormat(run, format);
                }
            }
            XmlCursor cursor1 = xwpfParagraph.getCTP().newCursor();
            cursor1.toNextSibling();
            xwpfParagraph = doc.insertNewParagraph(cursor1);
        }
        return xwpfParagraph;
    }

    private static File getImgFile(String imgSrc) throws IOException {
        if (imgSrc.startsWith(API_BASE_URL)) {
            imgSrc = "/" + imgSrc.replace(API_BASE_URL, "").replaceAll("//", "/");
            String savePath = FilePathConfig.switchSavePath(imgSrc);
            return new File(savePath);
        }
        if (imgSrc.startsWith("http")) {
            FileDTO tempFile = DownloadNetFileUtils.download(imgSrc, "tempImgFile");
            String savePath = FilePathConfig.switchSavePath(tempFile.getFileUrl());
            return new File(savePath);
        }
        return new File(imgSrc);
    }

    private static void runTextFormat(XWPFRun run, WordStrFormatDTO format) {
        if (null != format.getBold()) {
            run.setBold(format.getBold().booleanValue());
        }
        if (null != format.getItalic()) {
            run.setItalic(format.getItalic().booleanValue());
        }
        if (null != format.getUnderline() && format.getUnderline().booleanValue()) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        if (StringUtils.hasText((String)format.getFontFamily())) {
            run.setFontFamily(format.getFontFamily());
        }
        if (null != format.getFontSize()) {
            run.setFontSize(format.getFontSize().intValue());
        }
        if (StringUtils.hasText((String)format.getColor())) {
            run.setColor(format.getColor());
        }
    }

    private static int getPictureType(String imgSrc) {
        String extension;
        switch (extension = imgSrc.substring(imgSrc.lastIndexOf(46) + 1).toLowerCase()) {
            case "png": {
                return 6;
            }
            case "jpeg": {
                return 5;
            }
            case "jpg": {
                return 5;
            }
            case "gif": {
                return 8;
            }
        }
        return 6;
    }
}

