/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.office;

import com.kg.component.office.dto.WordStrFormatDTO;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.springframework.util.StringUtils;

public class WordWriteStringUtils {
    public static XWPFParagraph writeStrByKey(XWPFDocument doc, String key, String content, boolean isAppend) {
        return WordWriteStringUtils.writeStrByKey(doc, key, content, null, isAppend);
    }

    public static XWPFParagraph writeStrByKey(XWPFDocument doc, String key, String content, WordStrFormatDTO format, boolean isAppend) {
        key = "${" + key + "}";
        List paragraphs = doc.getParagraphs();
        XWPFParagraph result = WordWriteStringUtils.write(paragraphs, key, content, format, isAppend);
        if (result == null) {
            List tables = doc.getTables();
            for (XWPFTable table : tables) {
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        result = WordWriteStringUtils.write(cell.getParagraphs(), key, content, format, isAppend);
                        if (result == null) continue;
                        return result;
                    }
                }
            }
        }
        return result;
    }

    static XWPFParagraph write(List<XWPFParagraph> paragraphs, String key, String content, WordStrFormatDTO format, boolean isAppend) {
        for (XWPFParagraph paragraph : paragraphs) {
            Pattern pattern = Pattern.compile(Pattern.quote(key));
            StringBuilder sb = new StringBuilder();
            for (XWPFRun run : paragraph.getRuns()) {
                sb.append(run.getText(0));
            }
            String text = sb.toString();
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            for (int i = paragraph.getRuns().size() - 1; i > 0; --i) {
                paragraph.removeRun(i);
            }
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(0);
            text = matcher.replaceAll(content);
            run.setText(text, 0);
            if (format != null) {
                WordWriteStringUtils.runTextFormat(run, format);
            }
            if (isAppend) {
                paragraph.createRun().setText(key);
            }
            return paragraph;
        }
        return null;
    }

    public static XWPFParagraph writeStrNewline(XWPFDocument doc, String key, String content, boolean isAppend) {
        return WordWriteStringUtils.writeStrNewline(doc, key, content, null, isAppend);
    }

    public static XWPFParagraph writeStrNewline(XWPFDocument doc, String key, String content, WordStrFormatDTO format, boolean isAppend) {
        key = "${" + key + "}";
        for (XWPFParagraph paragraph : doc.getParagraphs()) {
            StringBuilder sb = new StringBuilder();
            for (XWPFRun run : paragraph.getRuns()) {
                sb.append(run.getText(0));
            }
            String text = sb.toString();
            Pattern pattern = Pattern.compile(Pattern.quote(key));
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            for (int i = paragraph.getRuns().size() - 1; i > 0; --i) {
                paragraph.removeRun(i);
            }
            XWPFRun run = (XWPFRun)paragraph.getRuns().get(0);
            run.setText(matcher.replaceAll(""), 0);
            if (StringUtils.hasText((String)run.text())) {
                XmlCursor cursor1 = paragraph.getCTP().newCursor();
                cursor1.toNextSibling();
                XWPFParagraph newParagraph = doc.insertNewParagraph(cursor1);
                XWPFRun newRun = newParagraph.createRun();
                newRun.setText(content, 0);
                paragraph = newParagraph;
                run = newRun;
            } else {
                run.setText(content, 0);
            }
            if (format != null) {
                WordWriteStringUtils.runTextFormat(run, format);
            }
            if (isAppend) {
                XmlCursor cursor2 = paragraph.getCTP().newCursor();
                cursor2.toNextSibling();
                doc.insertNewParagraph(cursor2).createRun().setText(key);
            }
            return paragraph;
        }
        return null;
    }

    public static void runTextFormat(XWPFRun run, WordStrFormatDTO format) {
        if (null != format.getBold()) {
            run.setBold(format.getBold().booleanValue());
        }
        if (null != format.getItalic()) {
            run.setItalic(format.getItalic().booleanValue());
        }
        if (null != format.getUnderline() && format.getUnderline().booleanValue()) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        }
        if (StringUtils.hasText((String)format.getFontFamily())) {
            run.setFontFamily(format.getFontFamily());
        }
        if (null != format.getFontSize()) {
            run.setFontSize(format.getFontSize().intValue());
        }
        if (StringUtils.hasText((String)format.getColor())) {
            run.setColor(format.getColor());
        }
    }

    private static WordStrFormatDTO getFormat(XWPFRun run) {
        WordStrFormatDTO format = new WordStrFormatDTO();
        format.setBold(run.isBold());
        format.setItalic(run.isItalic());
        format.setUnderline(run.getUnderline() == UnderlinePatterns.SINGLE);
        format.setFontFamily(run.getFontFamily());
        if (run.getFontSize() > 0) {
            format.setFontSize(run.getFontSize());
        }
        format.setColor(run.getColor());
        return format;
    }
}

