/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.pdf;

import cn.hutool.core.io.FileUtil;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.WorksheetCollection;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import java.io.File;
import org.springframework.util.StringUtils;

public class ExcelToPdfUtils {
    public static FileDTO toPdf(String fileUrl) throws Exception {
        return ExcelToPdfUtils.toPdf(fileUrl, null, -1);
    }

    public static FileDTO toPdf(String fileUrl, String outFolder) throws Exception {
        return ExcelToPdfUtils.toPdf(fileUrl, outFolder, -1);
    }

    public static FileDTO toPdf(String fileUrl, int sheetIndex) throws Exception {
        return ExcelToPdfUtils.toPdf(fileUrl, null, sheetIndex);
    }

    public static FileDTO toPdf(String fileUrl, String outFolder, int sheetIndex) throws Exception {
        WorksheetCollection sheets;
        String savePath = FilePathConfig.switchSavePath(fileUrl);
        Workbook workbook = new Workbook(savePath);
        if (sheetIndex >= 0 && sheetIndex < (sheets = workbook.getWorksheets()).getCount()) {
            for (int i = 0; i < sheets.getCount(); ++i) {
                if (i == sheetIndex) continue;
                sheets.get(i).setVisible(false);
            }
        }
        String xlsxName = savePath.substring(savePath.lastIndexOf("/"));
        String pdfSavePath = StringUtils.hasText((String)outFolder) ? FilePathConfig.SAVE_PATH + "/" + outFolder + "/" + xlsxName.substring(0, xlsxName.lastIndexOf(".")) + ".pdf" : savePath.substring(0, savePath.lastIndexOf(".")) + ".pdf";
        pdfSavePath = pdfSavePath.replaceAll("//", "/");
        FileUtil.mkParentDirs((String)pdfSavePath);
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setOnePagePerSheet(true);
        workbook.save(pdfSavePath, (SaveOptions)pdfSaveOptions);
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf("/") + 1));
        return fileDTO;
    }
}

