/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.pdf;

import cn.hutool.core.io.FileUtil;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import com.kg.component.utils.GuidUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.util.StringUtils;

public class ImgToPdfUtils {
    public static FileDTO toPdf(String imgUrl) throws IOException {
        return ImgToPdfUtils.toPdf(imgUrl, null, null, null);
    }

    public static FileDTO toPdf(String imgUrl, Integer width, Integer height) throws IOException {
        return ImgToPdfUtils.toPdf(imgUrl, null, width, height);
    }

    public static FileDTO toPdf(String imgUrl, String outFolder) throws IOException {
        return ImgToPdfUtils.toPdf(imgUrl, outFolder, null, null);
    }

    public static FileDTO toPdf(String imgUrl, String outFolder, Integer width, Integer height) throws IOException {
        PDDocument document = new PDDocument();
        String savePath = FilePathConfig.switchSavePath(imgUrl);
        ImgToPdfUtils.write(document, savePath, width.intValue(), height.intValue());
        String imgName = savePath.substring(savePath.lastIndexOf("/"));
        String pdfSavePath = StringUtils.hasText((String)outFolder) ? FilePathConfig.SAVE_PATH + "/" + outFolder + "/" + imgName.substring(0, imgName.lastIndexOf(".")) + ".pdf" : savePath.substring(0, savePath.lastIndexOf(".")) + ".pdf";
        pdfSavePath = pdfSavePath.replaceAll("//", "/");
        FileUtil.mkParentDirs((String)pdfSavePath);
        document.save(pdfSavePath);
        document.close();
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf("/") + 1));
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileExtend("pdf");
        return fileDTO;
    }

    public static FileDTO listToPdf(String[] imgUrls, String outFolder) throws IOException {
        return ImgToPdfUtils.listToPdf(Arrays.asList(imgUrls), outFolder, null, null);
    }

    public static FileDTO listToPdf(String[] imgUrls, String outFolder, Integer width, Integer height) throws IOException {
        return ImgToPdfUtils.listToPdf(Arrays.asList(imgUrls), outFolder, width, height);
    }

    public static FileDTO listToPdf(List<String> imgUrlList, String outFolder) throws IOException {
        return ImgToPdfUtils.listToPdf(imgUrlList, outFolder, null, null);
    }

    public static FileDTO listToPdf(List<String> imgUrlList, String outFolder, Integer width, Integer height) throws IOException {
        PDDocument document = new PDDocument();
        for (String imgUrl : imgUrlList) {
            String imgPath = FilePathConfig.switchSavePath(imgUrl);
            ImgToPdfUtils.write(document, imgPath, width.intValue(), height.intValue());
        }
        String pdfSavePath = FilePathConfig.SAVE_PATH + "/" + outFolder + "/" + GuidUtils.getUuid32() + ".pdf";
        pdfSavePath = pdfSavePath.replaceAll("//", "/");
        FileUtil.mkParentDirs((String)pdfSavePath);
        document.save(pdfSavePath);
        document.close();
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf("/") + 1));
        return fileDTO;
    }

    private static void write(PDDocument document, String imgPath, float maxWidth, float maxHeight) throws IOException {
        BufferedImage image = ImageIO.read(new File(imgPath));
        float width = image.getWidth();
        float height = image.getHeight();
        if (width > maxWidth || height > maxHeight) {
            float widthRatio = maxWidth / width;
            float heightRatio = maxHeight / height;
            float ratio = Math.min(widthRatio, heightRatio);
            width *= ratio;
            height *= ratio;
        }
        PDPage page = new PDPage(new PDRectangle(maxWidth, maxHeight));
        document.addPage(page);
        PDImageXObject pdImage = PDImageXObject.createFromFile((String)imgPath, (PDDocument)document);
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.drawImage(pdImage, 0.0f, maxHeight - height, width, height);
        contentStream.close();
    }
}

