/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.pdf;

import cn.hutool.core.io.FileUtil;
import com.aspose.words.Document;
import com.kg.component.file.FilePathConfig;
import com.kg.component.file.dto.FileDTO;
import java.io.File;
import org.springframework.util.StringUtils;

public class WordToPdfUtils {
    public static FileDTO toPdf(String fileUrl) throws Exception {
        return WordToPdfUtils.toPdf(fileUrl, null);
    }

    public static FileDTO toPdf(String fileUrl, String outFolder) throws Exception {
        String savePath = FilePathConfig.switchSavePath(fileUrl);
        Document document = new Document(savePath);
        String docxName = savePath.substring(savePath.lastIndexOf("/"));
        String pdfSavePath = StringUtils.hasText((String)outFolder) ? FilePathConfig.SAVE_PATH + "/" + outFolder + "/" + docxName.substring(0, docxName.lastIndexOf(".")) + ".pdf" : savePath.substring(0, savePath.lastIndexOf(".")) + ".pdf";
        pdfSavePath = pdfSavePath.replaceAll("//", "/");
        FileUtil.mkParentDirs((String)pdfSavePath);
        document.save(pdfSavePath, 40);
        FileDTO fileDTO = new FileDTO();
        fileDTO.setFileUrl(FilePathConfig.switchUrl(pdfSavePath));
        fileDTO.setFileExtend("pdf");
        fileDTO.setFileSize(new File(pdfSavePath).length());
        fileDTO.setFileName(pdfSavePath.substring(pdfSavePath.lastIndexOf("/") + 1));
        return fileDTO;
    }
}

