/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import cn.hutool.json.JSONObject;
import com.baidubce.http.ApiExplorerClient;
import com.baidubce.http.HttpMethodName;
import com.baidubce.model.ApiExplorerRequest;
import com.baidubce.model.ApiExplorerResponse;
import com.kg.component.redis.RedisUtils;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaiduAccessToken {
    @Resource
    private RedisUtils redisUtils;
    @Value(value="${com.kg.baidu.host}")
    private String BAIDU_API_HOST;
    @Value(value="${com.kg.baidu.client-id}")
    private String CLIENT_ID;
    @Value(value="${com.kg.baidu.client-secret}")
    private String CLIENT_SECRET;
    @Value(value="${com.kg.baidu.grant-type}")
    private String GRANT_TYPE;
    private final String ACCESS_TOKEN_REDIS_KEY = "baidu_access_token@";

    public String GetAccessToken() {
        try {
            if (this.redisUtils.hasKey("baidu_access_token@")) {
                return this.redisUtils.get("baidu_access_token@").toString();
            }
            ApiExplorerRequest request = new ApiExplorerRequest(HttpMethodName.POST, this.BAIDU_API_HOST);
            request.addHeaderParameter("Content-Type", "application/json;charset=UTF-8");
            request.addQueryParameter("client_id", this.CLIENT_ID);
            request.addQueryParameter("client_secret", this.CLIENT_SECRET);
            request.addQueryParameter("grant_type", this.GRANT_TYPE);
            ApiExplorerClient client = new ApiExplorerClient();
            ApiExplorerResponse response = client.sendRequest(request);
            JSONObject jsonObj = new JSONObject((Object)response.getResult());
            String accessToken = jsonObj.get((Object)"access_token").toString();
            Long expiresIn = jsonObj.getLong((Object)"expires_in");
            this.redisUtils.set("baidu_access_token@", (Object)accessToken, expiresIn - 1000L);
            return accessToken;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

