/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import java.util.Map;
import javax.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.stereotype.Component;

@Component
public class QuartzManagerUtils {
    @Resource
    private Scheduler scheduler;
    private static String JOB_GROUP_NAME = "QUARTZ_JOB_GROUP";
    private static String TRIGGER_GROUP_NAME = "QUARTZ_TRIGGER_GROUP";

    public void addJob(String jobName, Class<? extends Job> cls, String time) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(cls).withIdentity(jobName, JOB_GROUP_NAME).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addJob(String jobName, Class<? extends Job> cls, String time, Map<String, Object> parameter) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(cls).withIdentity(jobName, JOB_GROUP_NAME).build();
            jobDetail.getJobDataMap().put("parameterList", parameter);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, TRIGGER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String time) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String time, Map<String, Object> parameter) {
        try {
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).build();
            jobDetail.getJobDataMap().put("parameterList", parameter);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            if (!this.scheduler.isShutdown()) {
                this.scheduler.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyJobTime(String jobName, String time) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME);
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                Class objJobClass = jobDetail.getJobClass();
                this.removeJob(jobName);
                this.addJob(jobName, objJobClass, time);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void modifyJobTime(String triggerName, String triggerGroupName, String time) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)trigger.getCronExpression());
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)time)).build();
                this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJob(String jobName) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)TRIGGER_GROUP_NAME);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)JOB_GROUP_NAME);
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroupName);
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
            this.scheduler.pauseTrigger(triggerKey);
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startJobs() {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownJobs() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

