/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import java.math.BigDecimal;

public class StrTypeCheckUtils {
    public static boolean isNumeric(String str) {
        return StrTypeCheckUtils.isLong(str) || StrTypeCheckUtils.isInteger(str) || StrTypeCheckUtils.isBigDecimal(str) || StrTypeCheckUtils.isDouble(str) || StrTypeCheckUtils.isFloat(str);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isFloat(String str) {
        try {
            Float.parseFloat(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isBigDecimal(String str) {
        try {
            new BigDecimal(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDateAny(String str, String pattern) {
        return StrTypeCheckUtils.isDate(str) || StrTypeCheckUtils.isLocalDate(str) || StrTypeCheckUtils.isLocalDateTime(str);
    }

    public static boolean isDate(String str) {
        try {
            DateUtil.parse((CharSequence)str);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isLocalDate(String str) {
        try {
            LocalDateTimeUtil.parseDate((CharSequence)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalDateTime(String str) {
        try {
            LocalDateTimeUtil.parse((CharSequence)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

