/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.utils;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class UrlParams2JsonUtils {
    public static JSONObject toJson(String urlParams) {
        String[] params;
        JSONObject json = new JSONObject();
        for (String param : params = urlParams.split("&")) {
            String[] kv = param.split("=");
            if (kv.length < 2) continue;
            String key = kv[0];
            String v = param.substring(key.length() + 1);
            if (v.startsWith("'") && v.endsWith("'") || v.startsWith("\"") && v.endsWith("\"")) {
                v = v.substring(1, v.length() - 1);
            }
            json.put(key, (Object)v);
        }
        return json;
    }

    public static JSONObject toJsonDecode(String urlParams) throws UnsupportedEncodingException {
        String[] params;
        JSONObject json = new JSONObject();
        for (String param : params = urlParams.split("&")) {
            String[] kv = param.split("=");
            if (kv.length < 2) continue;
            String key = kv[0];
            String v = URLDecoder.decode(param.substring(key.length() + 1));
            if (v.startsWith("'") && v.endsWith("'") || v.startsWith("\"") && v.endsWith("\"")) {
                v = v.substring(1, v.length() - 1);
            }
            json.put(key, (Object)v);
        }
        return json;
    }

    public static String toUrlParams(String jsonStr) throws UnsupportedEncodingException {
        JSONObject json = JSONUtil.parseObj((String)jsonStr);
        StringBuilder sb = new StringBuilder();
        for (String key : json.keySet()) {
            sb.append(key).append("=").append(URLEncoder.encode(json.getStr((Object)key), "UTF-8")).append("&");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }
}

