/*
 * Decompiled with CFR 0.152.
 */
package com.kg.component.wechat.applet;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.kg.component.file.dto.FileDTO;
import com.kg.component.file.utils.UploadFileUtils;
import com.kg.component.redis.RedisUtils;
import com.kg.component.wechat.applet.WechatAppletConfig;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WechatAppletQRcodeUtils {
    @Resource
    private RedisUtils redisUtils;
    @Resource
    private WechatAppletConfig appletConfig;
    private final String APPLET_ACCESS_TOKEN_REDIS_KEY = "wechat_applet_access_token";

    public FileDTO getQRCode(String scene) {
        return this.getQRCode(scene, null, null);
    }

    public FileDTO getQRCode(String scene, String page) {
        return this.getQRCode(scene, page, null);
    }

    public FileDTO getQRCodeEnvVersion(String scene, String env_version) {
        return this.getQRCode(scene, null, env_version);
    }

    public FileDTO getQRCodeEnvVersion(String scene, String page, String env_version) {
        return this.getQRCode(scene, page, env_version);
    }

    private FileDTO getQRCode(String scene, String page, String env_version) {
        String accessToken = this.getAccessToken();
        JSONObject bodyObj = new JSONObject();
        bodyObj.set("scene", (Object)scene);
        bodyObj.set("env_version", (Object)(StringUtils.hasText((String)env_version) ? env_version : "release"));
        bodyObj.set("page", (Object)(StringUtils.hasText((String)page) ? page : "pages/index/index"));
        byte[] buffer = HttpUtil.createPost((String)(this.appletConfig.getQRCodeUrl() + "?access_token=" + accessToken)).body(bodyObj.toString()).execute().bodyBytes();
        return UploadFileUtils.bufferToFile(buffer, "wechat/applet/qrcode", "jpg");
    }

    private String getAccessToken() {
        try {
            if (this.redisUtils.hasKey("wechat_applet_access_token")) {
                return this.redisUtils.get("wechat_applet_access_token").toString();
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("appid", this.appletConfig.getAppId());
            paramMap.put("secret", this.appletConfig.getSecret());
            paramMap.put("grant_type", "client_credential");
            String result = HttpUtil.get((String)this.appletConfig.getAccessTokenUrl(), paramMap);
            JSONObject obj = JSONUtil.parseObj((String)result);
            String access_token = obj.getStr((Object)"access_token");
            if (StringUtils.hasText((String)access_token)) {
                this.redisUtils.set("wechat_applet_access_token", (Object)access_token, obj.getLong((Object)"expires_in") - 100L);
                return access_token;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

