/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.classgraph.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.InterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.RecursiveScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class FastClasspathScanner {
    private final ScanSpec scanSpec;
    private final ClasspathFinder classpathFinder;
    private final RecursiveScanner recursiveScanner;
    private final HashMap<String, HashMap<String, StaticFinalFieldMatchProcessor>> classNameToStaticFieldnameToMatchProcessor = new HashMap();
    private final HashMap<String, ClassInfo> relativePathToClassInfo = new HashMap();
    private ClassGraphBuilder classGraphBuilder;
    private final ArrayList<ClassMatcher> classMatchers = new ArrayList();
    public static boolean verbose = false;

    public FastClasspathScanner(String ... scanSpec) {
        this.classpathFinder = new ClasspathFinder();
        if (verbose) {
            Log.log("Classpath elements: " + this.classpathFinder.getUniqueClasspathElements());
        }
        this.scanSpec = new ScanSpec(scanSpec);
        this.recursiveScanner = new RecursiveScanner(this.classpathFinder, this.scanSpec);
        final ScanSpec scanSpecParsed = this.scanSpec;
        this.matchFilenameExtension("class", new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                if (!FastClasspathScanner.this.relativePathToClassInfo.containsKey(relativePath)) {
                    ClassInfo classInfo = ClassfileBinaryParser.readClassInfoFromClassfileHeader(relativePath, inputStream, FastClasspathScanner.this.classNameToStaticFieldnameToMatchProcessor, scanSpecParsed);
                    if (classInfo != null) {
                        FastClasspathScanner.this.relativePathToClassInfo.put(relativePath, classInfo);
                    }
                } else if (verbose) {
                    Log.log(relativePath.replace('/', '.') + " occurs more than once on classpath, ignoring all but first instance");
                }
            }
        });
    }

    public FastClasspathScanner overrideClasspath(String classpath) {
        this.classpathFinder.overrideClasspath(classpath);
        return this;
    }

    private <T> Class<? extends T> loadClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new RuntimeException("Exception while loading or initializing class " + className, e);
        }
    }

    private void checkClassNameIsNotBlacklisted(String className) {
        if (!this.scanSpec.classIsNotBlacklisted(className)) {
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted package. " + "You can explicitly override this by naming the class in the scan spec when you call the " + FastClasspathScanner.class.getSimpleName() + " constructor.");
        }
    }

    private String annotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassNameIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    private String[] annotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.annotationName(annotations[i]);
        }
        return annotationNames;
    }

    private String interfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassNameIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    private String[] interfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.interfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    private String classOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassNameIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    private String standardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassNameIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    private String className(Class<?> cls) {
        String className = cls.getName();
        this.checkClassNameIsNotBlacklisted(className);
        return className;
    }

    public List<String> getNamesOfAllClasses() {
        return this.getScanResults().getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.getScanResults().getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.getScanResults().getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.getScanResults().getNamesOfAllAnnotationClasses();
    }

    public FastClasspathScanner matchAllClasses(final ClassMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllClasses()) {
                    if (verbose) {
                        Log.log("Enumerating class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllStandardClasses(final ClassMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllStandardClasses()) {
                    if (verbose) {
                        Log.log("Enumerating standard class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllInterfaceClasses(final ClassMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllInterfaceClasses()) {
                    if (verbose) {
                        Log.log("Enumerating interface class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public FastClasspathScanner matchAllAnnotationClasses(final ClassMatchProcessor classEnumerationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                for (String className : FastClasspathScanner.this.getNamesOfAllAnnotationClasses()) {
                    if (verbose) {
                        Log.log("Enumerating annotation class: " + className);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(className);
                    classEnumerationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public <T> FastClasspathScanner matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superclassName = FastClasspathScanner.this.standardClassName(superclass);
                for (String subclassName : FastClasspathScanner.this.getNamesOfSubclassesOf(superclassName)) {
                    if (verbose) {
                        Log.log("Found subclass of " + superclassName + ": " + subclassName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subclassName);
                    subclassMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.getNamesOfSubclassesOf(this.standardClassName(superclass));
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        return this.getScanResults().getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.standardClassName(subclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        return this.getScanResults().getNamesOfSuperclassesOf(subclassName);
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String superinterfaceName = FastClasspathScanner.this.interfaceName(superinterface);
                for (String subinterfaceName : FastClasspathScanner.this.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    if (verbose) {
                        Log.log("Found subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(subinterfaceName);
                    subinterfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.interfaceName(superInterface));
    }

    public List<String> getNamesOfSubinterfacesOf(String superInterfaceName) {
        return this.getScanResults().getNamesOfSubinterfacesOf(superInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.interfaceName(subInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subinterfaceName) {
        return this.getScanResults().getNamesOfSuperinterfacesOf(subinterfaceName);
    }

    public <T> FastClasspathScanner matchClassesImplementing(final Class<T> implementedInterface, final InterfaceMatchProcessor<T> interfaceMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String implementedInterfaceName = FastClasspathScanner.this.interfaceName(implementedInterface);
                for (String implClass : FastClasspathScanner.this.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    if (verbose) {
                        Log.log("Found class implementing interface " + implementedInterfaceName + ": " + implClass);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(implClass);
                    interfaceMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.interfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementing(String implementedInterfaceName) {
        return this.getScanResults().getNamesOfClassesImplementing(implementedInterfaceName);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.interfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public <T> FastClasspathScanner matchClassesWithFieldOfType(final Class<T> fieldType, final ClassMatchProcessor classMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String fieldTypeName = FastClasspathScanner.this.className(fieldType);
                for (String klass : FastClasspathScanner.this.getNamesOfClassesWithFieldOfType(fieldTypeName)) {
                    if (verbose) {
                        Log.log("Found class with field of type " + fieldTypeName + ": " + klass);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(klass);
                    classMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        return this.getScanResults().getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithFieldOfType(Class<?> fieldType) {
        String fieldTypeName = fieldType.getName();
        this.checkClassNameIsNotBlacklisted(fieldTypeName);
        return this.getScanResults().getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public FastClasspathScanner matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.classMatchers.add(new ClassMatcher(){

            @Override
            public void lookForMatches() {
                String annotationName = FastClasspathScanner.this.annotationName(annotation);
                for (String classWithAnnotation : FastClasspathScanner.this.getNamesOfClassesWithAnnotation(annotationName)) {
                    if (verbose) {
                        Log.log("Found class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    Class cls = FastClasspathScanner.this.loadClass(classWithAnnotation);
                    classAnnotationMatchProcessor.processMatch(cls);
                }
            }
        });
        return this;
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.annotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.annotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.annotationName(metaAnnotation));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.getScanResults().getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> classOrInterface) {
        return this.getNamesOfAnnotationsOnClass(this.classOrInterfaceName(classOrInterface));
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.getScanResults().getNamesOfAnnotationsOnClass(classOrInterfaceName);
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(Class<?> annotation) {
        return this.getNamesOfMetaAnnotationsOnAnnotation(this.annotationName(annotation));
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.getScanResults().getNamesOfMetaAnnotationsOnAnnotation(annotationName);
    }

    private void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashMap<String, StaticFinalFieldMatchProcessor> fieldNameToMatchProcessor = this.classNameToStaticFieldnameToMatchProcessor.get(className);
        if (fieldNameToMatchProcessor == null) {
            fieldNameToMatchProcessor = new HashMap(2);
            this.classNameToStaticFieldnameToMatchProcessor.put(className, fieldNameToMatchProcessor);
        }
        fieldNameToMatchProcessor.put(fieldName, staticFinalFieldMatchProcessor);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(HashSet<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        return this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private static FileMatchProcessorWithContext fetchStreamContentsAndSendTo(final FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return new FileMatchProcessorWithContext(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                byte[] contents = new byte[lengthBytes];
                int bytesRead = Math.max(0, inputStream.read(contents));
                byte[] contentsRead = bytesRead == lengthBytes ? contents : Arrays.copyOf(contents, bytesRead);
                fileMatchContentsProcessorWithContext.processMatch(classpathElt, relativePath, contentsRead);
            }
        };
    }

    private static FileMatchProcessorWithContext ignoreClasspathContext(final FileMatchProcessor fileMatchProcessor) {
        return new FileMatchProcessorWithContext(){

            @Override
            public void processMatch(File classpathElement, String relativePath, InputStream inputStream, int lengthBytes) throws IOException {
                fileMatchProcessor.processMatch(relativePath, inputStream, lengthBytes);
            }
        };
    }

    private static FileMatchContentsProcessorWithContext ignoreClasspathContext(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchContentsProcessorWithContext(){

            @Override
            public void processMatch(File classpathElement, String relativePath, byte[] fileContents) throws IOException {
                fileMatchContentsProcessor.processMatch(relativePath, fileContents);
            }
        };
    }

    public FastClasspathScanner matchFilenamePattern(final String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                return this.pattern.matcher(relativePath).matches();
            }
        }, fileMatchProcessorWithContext));
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        return this.matchFilenamePattern(pathRegexp, FastClasspathScanner.ignoreClasspathContext(fileMatchProcessor));
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return this.matchFilenamePattern(pathRegexp, FastClasspathScanner.fetchStreamContentsAndSendTo(fileMatchContentsProcessorWithContext));
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePattern(pathRegexp, FastClasspathScanner.ignoreClasspathContext(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePath(final String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                return relativePath.equals(relativePathToMatch);
            }
        }, fileMatchProcessorWithContext));
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        return this.matchFilenamePath(relativePathToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchProcessor));
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return this.matchFilenamePath(relativePathToMatch, FastClasspathScanner.fetchStreamContentsAndSendTo(fileMatchContentsProcessorWithContext));
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePath(relativePathToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenamePathLeaf(final String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                String relativePathLeaf = relativePath.substring(relativePath.lastIndexOf(47) + 1);
                return relativePathLeaf.equals(this.leafToMatch);
            }
        }, fileMatchProcessorWithContext));
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        return this.matchFilenamePathLeaf(pathLeafToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchProcessor));
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return this.matchFilenamePathLeaf(pathLeafToMatch, FastClasspathScanner.fetchStreamContentsAndSendTo(fileMatchContentsProcessorWithContext));
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenamePathLeaf(pathLeafToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchContentsProcessor));
    }

    public FastClasspathScanner matchFilenameExtension(final String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.recursiveScanner.addFilePathMatcher(new RecursiveScanner.FilePathMatcher(new RecursiveScanner.FilePathTester(){
            private final String suffixToMatch;
            {
                this.suffixToMatch = "." + extensionToMatch.toLowerCase();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath) {
                return relativePath.toLowerCase().endsWith(this.suffixToMatch);
            }
        }, fileMatchProcessorWithContext));
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        return this.matchFilenameExtension(extensionToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchProcessor));
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return this.matchFilenameExtension(extensionToMatch, FastClasspathScanner.fetchStreamContentsAndSendTo(fileMatchContentsProcessorWithContext));
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        return this.matchFilenameExtension(extensionToMatch, FastClasspathScanner.ignoreClasspathContext(fileMatchContentsProcessor));
    }

    public List<File> getUniqueClasspathElements() {
        return this.classpathFinder.getUniqueClasspathElements();
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        return this.getScanResults().generateClassGraphDotFile(sizeX, sizeY);
    }

    public ClassGraphBuilder getScanResults() {
        if (this.classGraphBuilder == null) {
            throw new RuntimeException("Must call .scan() before attempting to get the results of the scan");
        }
        return this.classGraphBuilder;
    }

    public FastClasspathScanner scan() {
        long scanStart = System.currentTimeMillis();
        this.relativePathToClassInfo.clear();
        this.recursiveScanner.scan();
        this.classGraphBuilder = new ClassGraphBuilder(this.relativePathToClassInfo.values(), this.scanSpec);
        for (ClassMatcher classMatcher : this.classMatchers) {
            classMatcher.lookForMatches();
        }
        if (verbose) {
            Log.log("*** Time taken by .scan(): " + (System.currentTimeMillis() - scanStart) + " ms ***");
        }
        return this;
    }

    public boolean classpathContentsModifiedSinceScan() {
        long scanStart = System.currentTimeMillis();
        boolean modified = this.recursiveScanner.classpathContentsModifiedSinceScan();
        if (verbose) {
            Log.log("*** Time taken by .classpathContentsModifiedSinceScan(): " + (System.currentTimeMillis() - scanStart) + " ms ***");
        }
        return modified;
    }

    public long classpathContentsLastModifiedTime() {
        return this.recursiveScanner.classpathContentsLastModifiedTime();
    }

    public FastClasspathScanner verbose() {
        verbose = true;
        return this;
    }

    public static interface ClassMatcher {
        public void lookForMatches();
    }
}

