/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.AnnotationDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceDAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.StandardClassDAGNode;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import io.github.lukehutch.fastclasspathscanner.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassGraphBuilder {
    private final ArrayList<StandardClassDAGNode> standardClassNodes = new ArrayList();
    private final ArrayList<InterfaceDAGNode> interfaceNodes = new ArrayList();
    private final ArrayList<AnnotationDAGNode> annotationNodes = new ArrayList();
    private final HashMap<String, DAGNode> classNameToDAGNode = new HashMap();
    private final HashSet<String> nonWhitelistedExternalClassNames = new HashSet();
    private final LazyMap<String, DAGNode> classNameToStandardClassNode = this.lazyGetDAGNodeNames(this.standardClassNodes);
    private final LazyMap<String, DAGNode> interfaceNameToInterfaceNode = this.lazyGetDAGNodeNames(this.interfaceNodes);
    private final LazyMap<String, DAGNode> annotationNameToAnnotationNode = this.lazyGetDAGNodeNames(this.annotationNodes);
    private final LazyMap<String, List<String>> namesOfAllClasses = this.lazyGetKeys(this.classNameToStandardClassNode, this.interfaceNameToInterfaceNode, this.annotationNameToAnnotationNode);
    private final LazyMap<String, List<String>> namesOfAllStandardClasses = this.lazyGetKeys(this.classNameToStandardClassNode);
    private final LazyMap<String, List<String>> namesOfAllInterfaceClasses = this.lazyGetKeys(this.interfaceNameToInterfaceNode);
    private final LazyMap<String, List<String>> namesOfAllAnnotationClasses = this.lazyGetKeys(this.annotationNameToAnnotationNode);
    private final LazyMap<String, List<String>> classNameToSubclassNames = this.lazyGetConnectedClassNames(this.classNameToStandardClassNode, new MapToConnectedClassNames(){

        public List<String> getConnectedClassNames(DAGNode classNode) {
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{classNode.allSubNodes});
        }
    });
    private final LazyMap<String, List<String>> classNameToSuperclassNames = this.lazyGetConnectedClassNames(this.classNameToStandardClassNode, new MapToConnectedClassNames(){

        public List<String> getConnectedClassNames(DAGNode classNode) {
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{classNode.allSuperNodes});
        }
    });
    private final LazyMap<String, List<String>> fieldTypeToClassNames = this.sortedNonNullWithoutPlaceholders((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (StandardClassDAGNode node : ClassGraphBuilder.this.standardClassNodes) {
                for (DAGNode fieldType : node.fieldTypeNodes) {
                    MultiSet.put(this.map, fieldType.name, node.name);
                }
            }
        }
    });
    private final LazyMap<String, List<String>> interfaceNameToSubinterfaceNames = this.lazyGetConnectedClassNames(this.interfaceNameToInterfaceNode, new MapToConnectedClassNames(){

        public List<String> getConnectedClassNames(DAGNode interfaceNode) {
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{interfaceNode.allSubNodes});
        }
    });
    private final LazyMap<String, List<String>> interfaceNameToSuperinterfaceNames = this.lazyGetConnectedClassNames(this.interfaceNameToInterfaceNode, new MapToConnectedClassNames(){

        public List<String> getConnectedClassNames(DAGNode interfaceNode) {
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{interfaceNode.allSuperNodes});
        }
    });
    private final LazyMap<String, List<String>> interfaceNameToClassNames = this.sortedNonNullWithoutPlaceholders((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (StandardClassDAGNode classNode : ClassGraphBuilder.this.standardClassNodes) {
                for (DAGNode dAGNode : classNode.implementedInterfaceClassNodes) {
                    MultiSet.put(this.map, dAGNode.name, classNode.name);
                    for (DAGNode subclassNode : classNode.allSubNodes) {
                        MultiSet.put(this.map, dAGNode.name, subclassNode.name);
                    }
                    for (DAGNode superinterfaceNode : dAGNode.allSuperNodes) {
                        MultiSet.put(this.map, superinterfaceNode.name, classNode.name);
                        for (DAGNode subclassNode : classNode.allSubNodes) {
                            MultiSet.put(this.map, superinterfaceNode.name, subclassNode.name);
                        }
                    }
                }
            }
        }
    });
    private final LazyMap<String, List<String>> annotationNameToAnnotatedClassNames = this.lazyGetConnectedClassNames(this.annotationNameToAnnotationNode, new MapToConnectedClassNames(){

        @Override
        public Collection<String> getConnectedClassNames(DAGNode annotationNode) {
            ArrayList<DAGNode> annotatedClassNodes = new ArrayList<DAGNode>(((AnnotationDAGNode)annotationNode).annotatedClassNodes);
            for (DAGNode subNode : annotationNode.allSubNodes) {
                annotatedClassNodes.addAll(((AnnotationDAGNode)subNode).annotatedClassNodes);
            }
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{annotatedClassNodes});
        }
    });
    private final LazyMap<String, List<String>> classNameToAnnotationNames = this.sortedNonNullWithoutPlaceholders(LazyMap.invertMultiSet(this.annotationNameToAnnotatedClassNames, this.annotationNameToAnnotationNode));
    private final LazyMap<String, List<String>> metaAnnotationNameToAnnotatedAnnotationNames = this.lazyGetConnectedClassNames(this.annotationNameToAnnotationNode, new MapToConnectedClassNames(){

        @Override
        public Collection<String> getConnectedClassNames(DAGNode annotationNode) {
            return ClassGraphBuilder.getDAGNodeNames(new Collection[]{annotationNode.allSubNodes});
        }
    });
    private final LazyMap<String, List<String>> annotationNameToMetaAnnotationNames = this.sortedNonNullWithoutPlaceholders(LazyMap.invertMultiSet(this.metaAnnotationNameToAnnotatedAnnotationNames, this.annotationNameToAnnotationNode));

    public ClassGraphBuilder(Collection<ClassInfo> classInfoFromScan, ScanSpec scanSpec) {
        DAGNode newNode;
        ArrayList<ClassInfo> allClassInfo = new ArrayList<ClassInfo>(Utils.mergeScalaAuxClasses(classInfoFromScan));
        HashSet<String> externalSuperclasses = new HashSet<String>();
        HashSet<String> externalInterfaces = new HashSet<String>();
        HashSet<String> externalAnnotations = new HashSet<String>();
        ArrayList<String> scannedClasses = new ArrayList<String>();
        for (ClassInfo classInfo : allClassInfo) {
            if (classInfo.superclassNames != null) {
                externalSuperclasses.addAll(classInfo.superclassNames);
            }
            if (classInfo.interfaceNames != null) {
                externalInterfaces.addAll(classInfo.interfaceNames);
            }
            if (classInfo.annotationNames != null) {
                externalAnnotations.addAll(classInfo.annotationNames);
            }
            scannedClasses.add(classInfo.className);
        }
        externalSuperclasses.removeAll(scannedClasses);
        externalInterfaces.removeAll(scannedClasses);
        externalAnnotations.removeAll(scannedClasses);
        externalAnnotations.removeAll(externalInterfaces);
        for (String externalSuperclassName : externalSuperclasses) {
            newNode = new StandardClassDAGNode(externalSuperclassName);
            this.classNameToDAGNode.put(externalSuperclassName, newNode);
            this.standardClassNodes.add((StandardClassDAGNode)newNode);
            if (scanSpec.classIsWhitelisted(externalSuperclassName)) continue;
            this.nonWhitelistedExternalClassNames.add(externalSuperclassName);
        }
        for (String externalInterfaceName : externalInterfaces) {
            newNode = new InterfaceDAGNode(externalInterfaceName);
            this.classNameToDAGNode.put(externalInterfaceName, newNode);
            this.interfaceNodes.add((InterfaceDAGNode)newNode);
            if (scanSpec.classIsWhitelisted(externalInterfaceName)) continue;
            this.nonWhitelistedExternalClassNames.add(externalInterfaceName);
        }
        for (String externalAnnotationName : externalAnnotations) {
            newNode = new AnnotationDAGNode(externalAnnotationName);
            this.classNameToDAGNode.put(externalAnnotationName, newNode);
            this.annotationNodes.add((AnnotationDAGNode)newNode);
            if (scanSpec.classIsWhitelisted(externalAnnotationName)) continue;
            this.nonWhitelistedExternalClassNames.add(externalAnnotationName);
        }
        for (ClassInfo classInfo : allClassInfo) {
            DAGNode newNode2;
            String className = classInfo.className;
            if (classInfo.isAnnotation) {
                newNode2 = new AnnotationDAGNode(classInfo);
                this.classNameToDAGNode.put(className, newNode2);
                this.annotationNodes.add((AnnotationDAGNode)newNode2);
                continue;
            }
            if (classInfo.isInterface) {
                newNode2 = new InterfaceDAGNode(classInfo);
                this.classNameToDAGNode.put(className, newNode2);
                this.interfaceNodes.add((InterfaceDAGNode)newNode2);
                continue;
            }
            newNode2 = new StandardClassDAGNode(classInfo);
            this.classNameToDAGNode.put(className, newNode2);
            this.standardClassNodes.add((StandardClassDAGNode)newNode2);
        }
        for (DAGNode node : this.classNameToDAGNode.values()) {
            node.connect(this.classNameToDAGNode);
        }
        DAGNode.findTransitiveClosure(this.standardClassNodes);
        DAGNode.findTransitiveClosure(this.interfaceNodes);
        DAGNode.findTransitiveClosure(this.annotationNodes);
    }

    private LazyMap<String, List<String>> sortedNonNullWithoutPlaceholders(final LazyMap<String, ? extends Collection<String>> underlyingMap) {
        return new LazyMap<String, List<String>>(){

            @Override
            public List<String> generateValue(String key) {
                Collection classNameList = (Collection)underlyingMap.get(key);
                if (classNameList == null) {
                    return Collections.emptyList();
                }
                HashSet<String> listWithoutPlaceholders = new HashSet<String>();
                for (String className : classNameList) {
                    if (ClassGraphBuilder.this.nonWhitelistedExternalClassNames.contains(className)) continue;
                    listWithoutPlaceholders.add(className);
                }
                ArrayList<String> result = new ArrayList<String>(listWithoutPlaceholders);
                Collections.sort(result);
                return result;
            }
        };
    }

    @SafeVarargs
    private final LazyMap<String, List<String>> lazyGetKeys(final LazyMap<String, DAGNode> ... maps) {
        return this.sortedNonNullWithoutPlaceholders((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, Set<String>>(){
            private Set<String> union = null;

            @Override
            protected Set<String> generateValue(String ignored) {
                if (this.union != null) {
                    return this.union;
                }
                Set[] keySets = new Set[maps.length];
                for (int i = 0; i < maps.length; ++i) {
                    keySets[i] = maps[i].keySet();
                }
                this.union = Utils.union(keySets);
                return this.union;
            }
        });
    }

    @SafeVarargs
    private static List<String> getDAGNodeNames(Collection<DAGNode> ... nodeCollections) {
        int totSize = 0;
        for (Collection<DAGNode> coll : nodeCollections) {
            totSize += coll.size();
        }
        ArrayList<String> names = new ArrayList<String>(totSize);
        for (Collection<DAGNode> coll : nodeCollections) {
            for (DAGNode node : coll) {
                names.add(node.name);
            }
        }
        return names;
    }

    private LazyMap<String, DAGNode> lazyGetDAGNodeNames(final List<? extends DAGNode> nodes) {
        return new LazyMap<String, DAGNode>(){

            @Override
            public void initialize() {
                for (DAGNode node : nodes) {
                    this.map.put(node.name, node);
                }
            }
        };
    }

    private LazyMap<String, List<String>> lazyGetConnectedClassNames(final LazyMap<String, DAGNode> classNameToDAGNode, final MapToConnectedClassNames connectedClassNames) {
        return this.sortedNonNullWithoutPlaceholders((LazyMap<String, ? extends Collection<String>>)new LazyMap<String, Collection<String>>(){

            @Override
            protected Collection<String> generateValue(String className) {
                DAGNode classNode = (DAGNode)classNameToDAGNode.get(className);
                if (classNode == null) {
                    return null;
                }
                return connectedClassNames.getConnectedClassNames(classNode);
            }
        });
    }

    public List<String> getNamesOfAllClasses() {
        return this.namesOfAllClasses.get("");
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.namesOfAllStandardClasses.get("");
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.namesOfAllInterfaceClasses.get("");
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.namesOfAllAnnotationClasses.get("");
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        return this.classNameToSubclassNames.get(className);
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        return this.classNameToSuperclassNames.get(className);
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        return this.fieldTypeToClassNames.get(fieldTypeName);
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        return this.interfaceNameToSubinterfaceNames.get(interfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        return this.interfaceNameToSuperinterfaceNames.get(interfaceName);
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        return this.interfaceNameToClassNames.get(interfaceName);
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.annotationNameToAnnotatedClassNames.get(annotationName);
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.classNameToAnnotationNames.get(classOrInterfaceName);
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.annotationNameToMetaAnnotationNames.get(annotationName);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.metaAnnotationNameToAnnotatedAnnotationNames.get(metaAnnotationName);
    }

    private static String label(DAGNode node) {
        String className = node.name;
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#fff2b6\"];\n");
        for (DAGNode dAGNode : this.standardClassNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#b6e7ff\"];\n");
        for (DAGNode dAGNode : this.interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#f3c9ff\"];\n");
        for (DAGNode dAGNode : this.annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
        }
        buf.append("\n");
        for (StandardClassDAGNode standardClassDAGNode : this.standardClassNodes) {
            for (DAGNode dAGNode : standardClassDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\"\n");
            }
            for (DAGNode dAGNode : standardClassDAGNode.implementedInterfaceClassNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=diamond]\n");
            }
            for (DAGNode dAGNode : standardClassDAGNode.fieldTypeNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\" -> \"" + ClassGraphBuilder.label(standardClassDAGNode) + "\" [arrowtail=obox, dir=back]\n");
            }
        }
        for (InterfaceDAGNode interfaceDAGNode : this.interfaceNodes) {
            for (DAGNode dAGNode : interfaceDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (AnnotationDAGNode annotationDAGNode : this.annotationNodes) {
            for (DAGNode dAGNode : annotationDAGNode.directSuperNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(annotationDAGNode) + "\" -> \"" + ClassGraphBuilder.label(dAGNode) + "\" [arrowhead=dot]\n");
            }
            for (DAGNode dAGNode : annotationDAGNode.annotatedClassNodes) {
                buf.append("  \"" + ClassGraphBuilder.label(dAGNode) + "\" -> \"" + ClassGraphBuilder.label(annotationDAGNode) + "\" [arrowhead=dot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }

    private static interface MapToConnectedClassNames {
        public Collection<String> getConnectedClassNames(DAGNode var1);
    }
}

