/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.utils.Log;
import java.util.ArrayList;
import java.util.HashSet;

public class ScanSpec {
    private final ArrayList<String> whitelistedPackagePrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPackagePrefixes = new ArrayList();
    private final HashSet<String> whitelistedClassNames = new HashSet();
    private final HashSet<String> blacklistedClassNames = new HashSet();
    private final ArrayList<String> whitelistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPathPrefixes = new ArrayList();
    private final ArrayList<String> whitelistedJars = new ArrayList();
    private final ArrayList<String> blacklistedJars = new ArrayList();
    public final boolean scanJars;
    public final boolean scanNonJars;
    private static String[] BLACKLISTED_PACKAGES = new String[]{"java", "sun"};

    public ScanSpec(String[] scanSpecs) {
        for (String pkg : BLACKLISTED_PACKAGES) {
            String pkgPrefix = pkg + ".";
            this.blacklistedPackagePrefixes.add(pkgPrefix);
            this.blacklistedPathPrefixes.add(pkgPrefix.replace('.', '/'));
        }
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueWhitelistedPackagePrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPackagePrefixes = new HashSet<String>();
        boolean scanJars = true;
        boolean scanNonJars = true;
        for (String scanSpecEntry : scanSpecs) {
            boolean isJar;
            String spec = scanSpecEntry;
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (isJar = spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    Log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        scanJars = false;
                        continue;
                    }
                    scanNonJars = false;
                    continue;
                }
                if (blacklisted) {
                    this.blacklistedJars.add(spec);
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            if ((spec = spec.replace('/', '.')).startsWith(".")) {
                spec = spec.substring(1);
            }
            boolean isClassName = false;
            int lastDotIdx = spec.lastIndexOf(46);
            if (lastDotIdx > 0 && lastDotIdx < spec.length() - 1) {
                isClassName = Character.isUpperCase(spec.charAt(lastDotIdx + 1));
            }
            if (isClassName) {
                if (blacklisted) {
                    this.blacklistedClassNames.add(spec);
                    continue;
                }
                this.whitelistedClassNames.add(spec);
                continue;
            }
            spec = spec + ".";
            if (blacklisted) {
                uniqueBlacklistedPackagePrefixes.add(spec);
                uniqueBlacklistedPathPrefixes.add(spec.replace('.', '/'));
                continue;
            }
            uniqueWhitelistedPackagePrefixes.add(spec);
            uniqueWhitelistedPathPrefixes.add(spec.replace('.', '/'));
        }
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            Log.log("Ignoring blacklist of root package, it would prevent all scanning");
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.whitelistedJars.isEmpty()) {
            scanNonJars = false;
        }
        if (!scanJars && !scanNonJars) {
            Log.log("Scanning of jars and non-jars are both disabled -- re-enabling scanning of non-jars");
            scanNonJars = true;
        }
        if (uniqueWhitelistedPathPrefixes.isEmpty() || uniqueWhitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
            this.whitelistedPackagePrefixes.add("");
        } else {
            this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
            this.whitelistedPackagePrefixes.addAll(uniqueWhitelistedPackagePrefixes);
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        this.blacklistedPackagePrefixes.addAll(uniqueBlacklistedPackagePrefixes);
        this.whitelistedClassNames.removeAll(this.blacklistedClassNames);
        this.scanJars = scanJars;
        this.scanNonJars = scanNonJars;
        if (FastClasspathScanner.verbose) {
            Log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                Log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.whitelistedJars.isEmpty()) {
                Log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.blacklistedJars.isEmpty()) {
                Log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!scanJars) {
                Log.log("Scanning of jarfiles is disabled");
            }
            if (!scanNonJars) {
                Log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
    }

    private static boolean packageIsNotBlacklisted(String str, ArrayList<String> whitelist, ArrayList<String> blacklist) {
        boolean isWhitelisted = false;
        for (String whitelistPrefix : whitelist) {
            if (!str.startsWith(whitelistPrefix)) continue;
            isWhitelisted = true;
            break;
        }
        boolean isBlacklisted = false;
        for (String blacklistPrefix : blacklist) {
            if (!str.startsWith(blacklistPrefix)) continue;
            isBlacklisted = true;
            break;
        }
        return !isBlacklisted || isWhitelisted;
    }

    public boolean classIsNotBlacklisted(String className) {
        return !this.blacklistedClassNames.contains(className) || this.whitelistedClassNames.contains(className) || ScanSpec.packageIsNotBlacklisted(className, this.whitelistedPackagePrefixes, this.blacklistedPackagePrefixes);
    }

    private static boolean packageIsWhitelisted(String str, ArrayList<String> whitelist, ArrayList<String> blacklist) {
        boolean isWhitelisted = false;
        for (String whitelistPrefix : whitelist) {
            if (!str.startsWith(whitelistPrefix)) continue;
            isWhitelisted = true;
            break;
        }
        boolean isBlacklisted = false;
        for (String blacklistPrefix : blacklist) {
            if (!str.startsWith(blacklistPrefix)) continue;
            isBlacklisted = true;
            break;
        }
        return isWhitelisted && !isBlacklisted;
    }

    public boolean classIsWhitelisted(String className) {
        return (this.whitelistedClassNames.contains(className) || ScanSpec.packageIsWhitelisted(className, this.whitelistedPackagePrefixes, this.blacklistedPackagePrefixes)) && !this.blacklistedClassNames.contains(className);
    }

    public boolean pathIsWhitelisted(String relativePath) {
        return ScanSpec.packageIsWhitelisted(relativePath, this.whitelistedPathPrefixes, this.blacklistedPathPrefixes);
    }

    public ScanSpecPathMatch pathWhitelistMatchStatus(String path) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!path.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH;
        }
        for (String whitelistedPath : this.whitelistedPathPrefixes) {
            if (path.startsWith(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!whitelistedPath.startsWith(path) && !path.equals("/")) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    public boolean jarIsWhitelisted(String jarName) {
        return (this.whitelistedJars.isEmpty() || this.whitelistedJars.contains(jarName)) && !this.blacklistedJars.contains(jarName);
    }

    public static enum ScanSpecPathMatch {
        WITHIN_BLACKLISTED_PATH,
        WITHIN_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        NOT_WITHIN_WHITELISTED_PATH;

    }
}

