/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.EquinoxClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.JBossClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.URLClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WeblogicClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.Join;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClasspathFinder {
    private final List<String> rawClasspathElements = new ArrayList<String>();
    private static final List<ClassLoaderHandler> DEFAULT_CLASS_LOADER_HANDLERS = Arrays.asList(new URLClassLoaderHandler(), new EquinoxClassLoaderHandler(), new JBossClassLoaderHandler(), new WeblogicClassLoaderHandler());

    public void addClasspathElement(String pathElement) {
        this.rawClasspathElements.add(pathElement);
    }

    public void addClasspathElements(String pathStr) {
        if (pathStr != null && !pathStr.isEmpty()) {
            for (String pathElement : pathStr.split(File.pathSeparator)) {
                this.addClasspathElement(pathElement);
            }
        }
    }

    ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        if (scanSpec.overrideClasspath != null) {
            this.addClasspathElements(scanSpec.overrideClasspath);
        } else {
            ArrayList<ClassLoaderHandler> classLoaderHandlers = new ArrayList<ClassLoaderHandler>();
            classLoaderHandlers.addAll(DEFAULT_CLASS_LOADER_HANDLERS);
            classLoaderHandlers.addAll(scanSpec.extraClassLoaderHandlers);
            if (log != null && !classLoaderHandlers.isEmpty()) {
                ArrayList<String> classLoaderHandlerNames = new ArrayList<String>();
                for (ClassLoaderHandler classLoaderHandler : classLoaderHandlers) {
                    classLoaderHandlerNames.add(classLoaderHandler.getClass().getName());
                }
                log.log("ClassLoaderHandlers loaded: " + Join.join(", ", classLoaderHandlerNames));
            }
            for (ClassLoader classLoader : scanSpec.classLoaders) {
                boolean classloaderFound = false;
                for (ClassLoaderHandler handler : classLoaderHandlers) {
                    try {
                        if (!handler.handle(classLoader, this)) continue;
                        if (log != null) {
                            log.log("Classpath elements from ClassLoader " + classLoader.getClass().getName() + " were extracted by ClassLoaderHandler " + handler.getClass().getName());
                        }
                        classloaderFound = true;
                        break;
                    }
                    catch (Exception e) {
                        if (log == null) continue;
                        log.log("Exception in " + classLoader.getClass().getName() + ": " + e.toString());
                    }
                }
                if (classloaderFound || log == null) continue;
                log.log("Found unknown ClassLoader type, cannot scan classes: " + classLoader.getClass().getName());
            }
            this.addClasspathElements(System.getProperty("java.class.path"));
        }
    }

    public List<String> getRawClasspathElements() {
        return this.rawClasspathElements;
    }
}

