/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Array;
import java.util.HashSet;

public class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"org.eclipse.osgi.internal.loader.EquinoxClassLoader"};
    private boolean readSystemBundles = false;

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    private void addBundleFile(Object bundlefile, HashSet<Object> path, ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        if (bundlefile != null && path.add(bundlefile)) {
            Object basefile = ReflectionUtils.getFieldVal(bundlefile, "basefile");
            if (basefile != null) {
                Object cp = ReflectionUtils.getFieldVal(bundlefile, "cp");
                if (cp != null) {
                    classpathFinder.addClasspathElement(basefile.toString() + "/" + cp.toString(), classLoader, log);
                } else {
                    classpathFinder.addClasspathElement(basefile.toString(), classLoader, log);
                }
            }
            this.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "wrapped"), path, classLoader, classpathFinder, log);
            this.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "next"), path, classLoader, classpathFinder, log);
        }
    }

    @Override
    public void handle(ClassLoader classLoader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) throws Exception {
        Object manager = ReflectionUtils.getFieldVal(classLoader, "manager");
        Object entries = ReflectionUtils.getFieldVal(manager, "entries");
        if (entries != null) {
            int n = Array.getLength(entries);
            for (int i = 0; i < n; ++i) {
                Object entry = Array.get(entries, i);
                Object bundlefile = ReflectionUtils.getFieldVal(entry, "bundlefile");
                this.addBundleFile(bundlefile, new HashSet<Object>(), classLoader, classpathFinder, log);
            }
        }
        if (!this.readSystemBundles) {
            Object delegate = ReflectionUtils.getFieldVal(classLoader, "delegate");
            Object container = ReflectionUtils.getFieldVal(delegate, "container");
            Object storage = ReflectionUtils.getFieldVal(container, "storage");
            Object moduleContainer = ReflectionUtils.getFieldVal(storage, "moduleContainer");
            Object moduleDatabase = ReflectionUtils.getFieldVal(moduleContainer, "moduleDatabase");
            Object modulesById = ReflectionUtils.getFieldVal(moduleDatabase, "modulesById");
            Object module0 = ReflectionUtils.invokeMethod(modulesById, "get", Object.class, 0L);
            Object bundle = ReflectionUtils.invokeMethod(module0, "getBundle");
            Object bundleContext = ReflectionUtils.invokeMethod(bundle, "getBundleContext");
            Object bundles = ReflectionUtils.invokeMethod(bundleContext, "getBundles");
            if (bundles != null) {
                int n = Array.getLength(bundles);
                for (int i = 0; i < n; ++i) {
                    int fileIdx;
                    Object equinoxBundle = Array.get(bundles, i);
                    Object module = ReflectionUtils.getFieldVal(equinoxBundle, "module");
                    String location = (String)ReflectionUtils.getFieldVal(module, "location");
                    if (location == null || (fileIdx = location.indexOf("file:")) < 0) continue;
                    location = location.substring(fileIdx);
                    classpathFinder.addClasspathElement(location, classLoader, log);
                }
            }
            this.readSystemBundles = true;
        }
    }
}

