/*
 * Copyright 2016 Liam Williams <liam.williams@zoho.com>.
 *
 * This file is part of fluent-bdd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.theangrydev.fluentbdd.core;

/**
 * When the {@link #prime()} method is invoked, any setup necessary for this
 * to affect the system under test should be performed immediately.
 *
 * For example, this could mean priming a HTTP stub with a canned response.
 *
 * This class should act as a builder for use in {@link FluentBddCommands}.
 *
 * @see <a href="https://en.wikipedia.org/wiki/Builder_pattern#Java_example">The Builder Pattern</a>
 */
@FunctionalInterface
public interface Given {

    /**
     * Prime the given immediately, which will make a change that is visible to
     * the system under test (that is implemented in the {@link When}.
     */
    void prime();
}
